package computercraftsc.client.gui;

public class GuiConstants {
	public static final int BACKGROUND_IMAGE_WIDTH = 256;
	public static final int BACKGROUND_IMAGE_HEIGHT = 192;

	// Slot pixel width and height.
	public static final int SLOT_BORDER_WIDTH = 1;
	public static final int SLOT_SIZE = 16 + 2 * SLOT_BORDER_WIDTH;

	// GUI inventory placement and spacing constants.
	public static final int SPACE_BETWEEN_CODING_AND_PROGRAMMING = 18;
	public static final int SPACE_BETWEEN_PLAYER_BAR_AND_INVENTORY = 6;
	public static final int SPACE_BETWEEN_PLAYERTURTLE_INVENTORIES = 8;
	public static final int X_OFFSET_LEFT = 8;
	public static final int Y_OFFSET_TOP = 26;
	public static final int Y_OFFSET_TOP_INVENTORY_NAME = 9;

	// Player inventory constants.
	public static final int PLAYER_INVENTORY_COLUMNS = 9;
	public static final int PLAYER_INVENTORY_ROWS = 4;
	public static final int PLAYER_INVENTORY_SLOT_INDEX_OFFSET = 0; // Loaded as first inventory.
	public static final int PLAYER_INVENTORY_TOTAL_SLOTS = PLAYER_INVENTORY_COLUMNS * PLAYER_INVENTORY_ROWS;
	public static final int PLAYER_INVENTORY_WIDTH = PLAYER_INVENTORY_COLUMNS * SLOT_SIZE;
	public static final int PLAYER_INVENTORY_HEIGHT = PLAYER_INVENTORY_ROWS * SLOT_SIZE;

	// Turtle inventory constants.
	public static final int TURTLE_INVENTORY_COLUMNS = 4;
	public static final int TURTLE_INVENTORY_ROWS = 4;
	public static final int TURTLE_INVENTORY_SLOT_INDEX_OFFSET = PLAYER_INVENTORY_SLOT_INDEX_OFFSET + PLAYER_INVENTORY_TOTAL_SLOTS;
	public static final int TURTLE_INVENTORY_TOTAL_SLOTS = TURTLE_INVENTORY_COLUMNS * TURTLE_INVENTORY_ROWS;
	public static final int TURTLE_INVENTORY_X_OFFSET = X_OFFSET_LEFT + PLAYER_INVENTORY_WIDTH + SPACE_BETWEEN_PLAYERTURTLE_INVENTORIES;
	public static final int TURTLE_INVENTORY_WIDTH = TURTLE_INVENTORY_COLUMNS * SLOT_SIZE;
	public static final int TURTLE_INVENTORY_HEIGHT = TURTLE_INVENTORY_ROWS * SLOT_SIZE;

	// Coding inventory constants.
	public static final int CODING_INVENTORY_COLUMNS = 8;
	public static final int CODING_INVENTORY_VISIBLE_ROWS = 7;
	public static final int CODING_INVENTORY_TOTAL_ROWS = 20;
	public static final int CODING_INVENTORY_SLOT_INDEX_OFFSET = TURTLE_INVENTORY_SLOT_INDEX_OFFSET + TURTLE_INVENTORY_TOTAL_SLOTS;
	public static final int CODING_INVENTORY_TOTAL_SLOTS = CODING_INVENTORY_COLUMNS * CODING_INVENTORY_TOTAL_ROWS;
	public static final int CODING_INVENTORY_X_OFFSET = X_OFFSET_LEFT;
	public static final int CODING_INVENTORY_Y_OFFSET = Y_OFFSET_TOP;
	public static final int CODING_INVENTORY_WIDTH = CODING_INVENTORY_COLUMNS * SLOT_SIZE;
	public static final int CODING_INVENTORY_HEIGHT = CODING_INVENTORY_VISIBLE_ROWS * SLOT_SIZE;

	// Programming inventory constants.
	public static final int PROGRAMMING_INVENTORY_COLUMNS = 4;
	public static final int PROGRAMMING_INVENTORY_ROWS = 7;
	public static final int PROGRAMMING_INVENTORY_SLOT_INDEX_OFFSET = CODING_INVENTORY_SLOT_INDEX_OFFSET + CODING_INVENTORY_TOTAL_SLOTS;
	public static final int PROGRAMMING_INVENTORY_TOTAL_SLOTS = PROGRAMMING_INVENTORY_COLUMNS * PROGRAMMING_INVENTORY_ROWS;
	public static final int PROGRAMMING_INVENTORY_X_OFFSET = X_OFFSET_LEFT + CODING_INVENTORY_WIDTH + SPACE_BETWEEN_CODING_AND_PROGRAMMING;
	public static final int PROGRAMMING_INVENTORY_WIDTH = PROGRAMMING_INVENTORY_COLUMNS * SLOT_SIZE;
	public static final int PROGRAMMING_INVENTORY_HEIGHT = PROGRAMMING_INVENTORY_ROWS * SLOT_SIZE;

	// Terminal GUI constants.
	public static final int TERMINAL_ROWS = 12;
	public static final int TERMINAL_WIDTH = 220;
	public static final int TERMINAL_HEIGHT = 126;
	public static final int TERMINAL_TEXT_X_OFFSET = 4;
	public static final int TERMINAL_TEXT_Y_OFFSET = 4;

	// Bottom left action button positions/spacing on inventory tabs.
	public static final int ACTION_BUTTON_Y_OFFSET = 171;
	public static final int ACTION_BUTTON_X_OFFSET = 6;
	public static final int ACTION_BUTTON_LENGTH = 27;
	public static final int INVENTORY_TAB_WIDTH = ACTION_BUTTON_LENGTH + 1;
	public static final int INVENTORY_TAB_HEIGHT = ACTION_BUTTON_LENGTH;
	public static final int INVENTORY_TAB_Y_OFFSET = 165;
	public static final int OFFSET_BETWEEN_INVENTORY_TABS = INVENTORY_TAB_WIDTH - 1;

	// Coordinates used to place inventory slots at to make them invisible.
	public static final int INVISIBLE_LOCATION = 500;

	// GUI scroll bar constants.
	public static final int SCROLL_BAR_WIDTH = 8;
	public static final int SCROLL_BAR_BUTTONS_HEIGHT = 4;

	// Close button position.
	public static final int CLOSE_BUTTON_X_OFFSET = 240;
	public static final int CLOSE_BUTTON_Y_OFFSET = 0;

	// Run button position.
	public static final int RUN_BUTTON_X_OFFSET = 231;
	public static final int RUN_BUTTON_Y_OFFSET = 168;

	// Garbage button position.
	public static final int GARBAGE_BUTTON_X_OFFSET = 200;
	public static final int GARBAGE_BUTTON_Y_OFFSET = 168;

	// GUI screen name y offset.
	public static final int GUI_SCREEN_NAME_Y_OFFSET = 5;
}
