package computercraftsc.client.gui;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.items.ItemProgrammingIcon;
import net.minecraft.item.ItemStack;

public class ProgrammingIconRetriever {
	
	/**
	 * List containing all {@link ItemProgrammingIcon} instances.
	 * The index of these icons in the list is considered their ID.
	 */
	private static final List<ItemProgrammingIcon> ORDERED_PROGRAMMING_ICON_LIST = Collections.unmodifiableList(Arrays.asList(
			RegistrySC.ModItems.MOVE_FORWARD.get(),
			RegistrySC.ModItems.MOVE_BACK.get(),
			RegistrySC.ModItems.TURN_LEFT.get(),
			RegistrySC.ModItems.TURN_RIGHT.get(),
			RegistrySC.ModItems.MOVE_UP.get(),
			RegistrySC.ModItems.MOVE_DOWN.get(),
			RegistrySC.ModItems.PLACE.get(),
			RegistrySC.ModItems.PLACE_UP.get(),
			RegistrySC.ModItems.PLACE_DOWN.get(),
			RegistrySC.ModItems.DIG.get(),
			RegistrySC.ModItems.DIG_DOWN.get(),
			RegistrySC.ModItems.DIG_UP.get(),
			RegistrySC.ModItems.DROP.get(),
			RegistrySC.ModItems.DROP_DOWN.get(),
			RegistrySC.ModItems.DROP_UP.get(),
			RegistrySC.ModItems.SUCK.get(),
			RegistrySC.ModItems.SUCK_DOWN.get(),
			RegistrySC.ModItems.SUCK_UP.get(),
			RegistrySC.ModItems.ATTACK.get(),
			RegistrySC.ModItems.ATTACK_DOWN.get(),
			RegistrySC.ModItems.ATTACK_UP.get(),
			RegistrySC.ModItems.SET_REDSTONE.get(),
			RegistrySC.ModItems.SET_REDSTONE_DOWN.get(),
			RegistrySC.ModItems.SET_REDSTONE_UP.get(),
			RegistrySC.ModItems.SAY.get(),
			RegistrySC.ModItems.COMMENT.get(),
			RegistrySC.ModItems.SELECT.get(),
			RegistrySC.ModItems.REPEAT.get(),
			RegistrySC.ModItems.IF.get(),
			RegistrySC.ModItems.WHILE.get(),
			RegistrySC.ModItems.FOR.get(),
			RegistrySC.ModItems.DO.get(),
			RegistrySC.ModItems.THEN.get(),
			RegistrySC.ModItems.ELSE_IF.get(),
			RegistrySC.ModItems.ELSE.get(),
			RegistrySC.ModItems.TO.get(),
			RegistrySC.ModItems.BREAK.get(),
			RegistrySC.ModItems.END.get(),
			RegistrySC.ModItems.NUMBER.get(),
			RegistrySC.ModItems.STRING.get(),
			RegistrySC.ModItems.VARIABLE.get(),
			RegistrySC.ModItems.RANDOM_NUMBER.get(),
			RegistrySC.ModItems.RANDOM_BOOLEAN.get(),
			RegistrySC.ModItems.GET_ITEM_COUNT.get(),
			RegistrySC.ModItems.DETECT.get(),
			RegistrySC.ModItems.DETECT_DOWN.get(),
			RegistrySC.ModItems.DETECT_UP.get(),
			RegistrySC.ModItems.COMPARE.get(),
			RegistrySC.ModItems.COMPARE_DOWN.get(),
			RegistrySC.ModItems.COMPARE_UP.get(),
			RegistrySC.ModItems.INSPECT.get(),
			RegistrySC.ModItems.INSPECT_DOWN.get(),
			RegistrySC.ModItems.INSPECT_UP.get(),
			RegistrySC.ModItems.INSPECT_SLOT.get(),
			RegistrySC.ModItems.BLOCK.get(),
			RegistrySC.ModItems.ITEM.get(),
			RegistrySC.ModItems.QUERY_REDSTONE.get(),
			RegistrySC.ModItems.QUERY_REDSTONE_DOWN.get(),
			RegistrySC.ModItems.QUERY_REDSTONE_UP.get(),
			RegistrySC.ModItems.AND.get(),
			RegistrySC.ModItems.OR.get(),
			RegistrySC.ModItems.NOT.get(),
			RegistrySC.ModItems.TRUE.get(),
			RegistrySC.ModItems.FALSE.get(),
			RegistrySC.ModItems.EQUAL_TO.get(),
			RegistrySC.ModItems.NOT_EQUAL_TO.get(),
			RegistrySC.ModItems.LESS_THAN.get(),
			RegistrySC.ModItems.LESS_THAN_OR_EQUAL_TO.get(),
			RegistrySC.ModItems.GREATER_THAN.get(),
			RegistrySC.ModItems.GREATER_THAN_OR_EQUAL_TO.get(),
			RegistrySC.ModItems.PLUS.get(),
			RegistrySC.ModItems.MINUS.get(),
			RegistrySC.ModItems.TIMES.get(),
			RegistrySC.ModItems.DIVIDED_BY.get(),
			RegistrySC.ModItems.SLEEP.get()));
	
	/**
	 * Map containing all {@link ItemProgrammingIcon} instances with their ID as key.
	 */
	private static final Map<ItemProgrammingIcon, Integer> PROGRAMMING_ICON_ID_MAP;
	
	static {
		Map<ItemProgrammingIcon, Integer> programmingIconIDMap = new HashMap<>();
		for(int i = 0; i < ORDERED_PROGRAMMING_ICON_LIST.size(); i++) {
			programmingIconIDMap.put(ORDERED_PROGRAMMING_ICON_LIST.get(i), i);
		}
		PROGRAMMING_ICON_ID_MAP = Collections.unmodifiableMap(programmingIconIDMap);
	}
	
	public ProgrammingIconRetriever() {
	}
	
	public int getProgrammingIconId(ItemProgrammingIcon icon) {
		return PROGRAMMING_ICON_ID_MAP.get(icon);
	}
	
	public ItemStack getItemStackFromIdAndAmount(int index, int amount) {
		return new ItemStack(ORDERED_PROGRAMMING_ICON_LIST.get(index), amount);
	}
	
	public List<ItemProgrammingIcon> getOrderedProgrammingIcons() {
		return ORDERED_PROGRAMMING_ICON_LIST;
	}
}
