package computercraftsc.client.gui;

import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

/**
 * Represents the state of the turtle GUI.
 * The GUI state is used to determine which slots and GUI elements are to be shown on the screen.
 */
public enum TurtleInventoryScreen {
	
	/**
	 * State where you can see both the player and turtle inventories.
	 */
	INVENTORY_SCREEN("gui.computercraftsc:inventories"),
	
	/**
	 * State where you can see the coding and programming inventories.
	 */
	PROGRAMMING_SCREEN("gui.computercraftsc:writing_code"),
	
	/**
	 * State where you can see the terminal in which the transpiled Lua code from the coding inventory is shown.
	 */
	TERMINAL_SCREEN("gui.computercraftsc:written_code");
	
	private final String screenNameTranslationKey;
	
	private TurtleInventoryScreen(String screenNameTranslationKey) {
		this.screenNameTranslationKey = screenNameTranslationKey;
	}
	
	/**
	 * Get the screen name of the screen represented by the GUI state.
	 * @return The translated user-friendly screen name, which should be put on the top of the GUI screen.
	 */
	@OnlyIn(Dist.CLIENT)
	public String getScreenName() {
		return I18n.format(this.screenNameTranslationKey);
	}
}
