package computercraftsc.client.gui.container.slot;

import computercraftsc.shared.items.ItemProgrammingIcon;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class ProgrammingSlot extends Slot {
	
	public ProgrammingSlot(IInventory inventory, int index, int xPosition, int yPosition) {
		super(inventory, index, xPosition, yPosition);
	}
	
	@Override
	public boolean isItemValid(ItemStack stack) {
		
		// Only allow ItemProgrammingIcon items in this inventory.
		return stack.isEmpty() || stack.getItem() instanceof ItemProgrammingIcon;
	}
	
	@Override
	public ItemStack decrStackSize(int amount) {
		ItemStack ret = super.decrStackSize(amount);
		this.onSlotChanged();
		return ret;
	}
}
