package computercraftsc.client.gui.inventories;

import net.minecraft.item.ItemStack;

/**
 * This Inventory holds ButtonSlots that use to trigger functions when clicked.
 * These Inventories should always only have a size of 1. The Image used for these inventories
 * is represented by and ItemStakc with a size of 1
 */
public class ActionButtonInventory extends Inventory {
	protected ItemStack imageStack; //Image of the Button

	/**
	 * Alot of the parameters should always remain constant so we pass very little attribute,
	 * @param image This an Item, but will be changed to an ItemStack.
	 */
	public ActionButtonInventory(ItemStack image) {
		super(1, 1);
		this.imageStack = image;
		this.inventory[0] = this.imageStack;
	}

	protected void setImage(ItemStack icon) {
		this.inventory[0] = icon;
	}

	protected ItemStack getImage() {
		return this.inventory[0];
	}

	@Override
	public int getInventoryStackLimit() {
		return 1;
	}

}
