package computercraftsc.client.gui.inventories;

import computercraftsc.client.gui.container.slot.PlayerSlot;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

import static computercraftsc.client.gui.GuiConstants.PLAYER_INVENTORY_COLUMNS;
import static computercraftsc.client.gui.GuiConstants.PLAYER_INVENTORY_ROWS;

/**
 * This class manages the Inventory of the Minecraft Player.
 * Because of this it holds a InventoryPlayer.
 * This Class Encapsulates the InventoryPlayer with information on the Columns and Rows
 */
public class CCSCPlayerInventory extends Inventory {
	private PlayerInventory playerInv = null;

	/**
	 * The columns and rows are the standard Minecraft Amount
	 * But as we do not know the Player at the point of creation, it is set as null.
	 */
	public CCSCPlayerInventory() {
		super(PLAYER_INVENTORY_COLUMNS, PLAYER_INVENTORY_ROWS);
	}

	/**
	 * Returns a {@link PlayerSlot} for the underlying {@link InventoryPlayer}.
	 */
	@Override
	public Slot createSlot(int index, int xPosition, int yPosition) {
		return new PlayerSlot(this.playerInv, index, xPosition, yPosition);
	}

	/**
	 * This method sets the InventoryPlayer. This is called whenever a player opens the turtle. This way we know which
	 * player's inventory we should show.
	 * @param inventoryPlayer The Inventory of the Player which inventory should be shown
	 */
	public void setInventoryPlayer(PlayerInventory inventoryPlayer) {
		this.playerInv = inventoryPlayer;
		this.inventory = inventoryPlayer.mainInventory.toArray(new ItemStack[0]);
	}
}
