package computercraftsc.client.gui.inventories;

import net.minecraft.item.ItemStack;

/**
 * This class is to be used want you want to create a button, that changes image based on the state.
 * Currently is supports only 2 settings, and can toggle between the two Images
 */
public class ToggleButtonInventory extends ActionButtonInventory {
	private final ItemStack primaryImage;
	private final ItemStack secundaryImage;

	/**
	 * Creates a new single-slot toggle button inventory using the given primary and secundary {@link ItemStack}s as
	 * visual contents for the slot.
	 * Initially, the primary {@link ItemStack} will be placed in the inventory.
	 * @param primaryImage - The primary {@link ItemStack} to use as button image.
	 * @param secundaryImage - The secundary {@link ItemStack} to use as button image.
	 */
	public ToggleButtonInventory(ItemStack primaryImage, ItemStack secundaryImage) {
		super(primaryImage);
		this.primaryImage = primaryImage;
		this.secundaryImage = secundaryImage;
		this.imageStack = primaryImage;
	}

	/**
	 * Sets the primary or the secundary {@link ItemStack} as image to be shown.
	 * @param showPrimary - If {@code true}, the primary image will be shown.
	 * Otherwise, the secundary image will be shown.
	 */
	public void showPrimaryImage(boolean showPrimary) {
		this.setImage(showPrimary ? this.primaryImage : this.secundaryImage);
	}

	/**
	 * Gets whether the primary or secundary image is being shown.
	 * @return {@code true} if the primary image is being shown, {@code false} otherwise.
	 */
	public boolean isShowingPrimaryImage() {
		return this.getImage() == this.primaryImage;
	}
}
