package computercraftsc.client.gui.inventories.config;

import net.minecraft.nbt.CompoundNBT;

/**
 * Represents a code item entry in the programming inventory.
 * @author P.J.S. Kools
 */
public class CodeItemEntry implements Comparable<CodeItemEntry> {

	private final int id;
	private final int amount;

	/**
	 * Create a new {@link CodeItemEntry}.
	 * @param id - The identifier for this code item.
	 * @param amount - The amount of available items of this type.
	 */
	public CodeItemEntry(int id, int amount) {
		this.id = id;
		this.amount = amount;
	}

	@Override
	public String toString() {
		return "Config{iconId=" + this.id + ", amount=" + this.amount + "}";
	}

	public int getAmount() {
		return this.amount;
	}

	public int getIconId() {
		return this.id;
	}

	public static CodeItemEntry readFromNBT(CompoundNBT tag) {
		return new CodeItemEntry(tag.getByte("id"), tag.getByte("amount"));
	}

	public CompoundNBT createCompoundNBT() {
		CompoundNBT compound = new CompoundNBT();
		compound.putInt("amount", this.amount);
		compound.putInt("id", this.id);
		return compound;
	}

	@Override
	public int compareTo(CodeItemEntry other) {
		return Integer.compare(this.getIconId(), other.getIconId());
	}
}
