package computercraftsc.client.gui.widgets;

public abstract class WidgetButton extends Widget {
	
	private IButtonListener btnListener;
	private boolean locked = false;
	
	protected WidgetButton(int x, int y, int width, int height, IButtonListener btnListener) {
		super(x, y, width, height);
		this.btnListener = btnListener;
	}
	
	public boolean isLocked() {
		return this.locked;
	}
	
	public void setLocked(boolean locked) {
		this.locked = locked;
	}
	
	@Override
	public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
		if(mouseButton == 0 && mouseX >= 0 && mouseX < this.getWidth()
				&& mouseY >= 0 && mouseY < this.getHeight() && !this.locked) {
			this.playClickSound();
			this.onPressed();
			return true;
		}
		return false;
	}
	
	protected void onPressed() {
		if(this.btnListener != null) {
			this.btnListener.onButtonPressed(this);
		}
	}
	
	public static interface IButtonListener {
		void onButtonPressed(WidgetButton widgetButton);
	}
}
