package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;

/**
 * This {@link Widget} wrapper allows {@link TwoLayerStateDrawable} {@link Widget}s to be drawn at a custom depth
 * (z coordinate).
 * @author P.J.S. Kools
 */
public class WidgetDepthWrapper extends Widget implements TwoLayerStateDrawable {
	
	private final Widget widget;
	private final int depth;
	
	/**
	 * Creates a new widget depth wrapper with the given depth.
	 * @param widget - The {@link Widget} to wrap.
	 * @param depth - The depth at which to draw the widget. Minecraft uses the following depths internally:
	 * <ul>
	 * <li>0: Default for drawing GUI contents.</li>
	 * <li>100: Drawing empty slot background sprites.</li>
	 * <li>200: Drawing item stacks.</li>
	 * </ul>
	 */
	public WidgetDepthWrapper(Widget widget, int depth) {
		super(widget.getRelXPosition(), widget.getRelYPosition(), widget.getWidth(), widget.getHeight());
		this.widget = widget;
		this.depth = depth;
	}
	
	@Override
	public void setParent(Widget parent) {
		super.setParent(parent);
		this.widget.setParent(parent);
	}
	
	@Override
	public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
		if(this.widget instanceof TwoLayerStateDrawable) {
			RenderSystem.pushMatrix();
			RenderSystem.translatef(0, 0, this.depth);
			((TwoLayerStateDrawable) this.widget).drawGuiContainerBackgroundLayer(matrixStack, mouseX, mouseY);
			RenderSystem.popMatrix();
		}
	}
	
	@Override
	public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
		if(this.widget instanceof TwoLayerStateDrawable) {
			RenderSystem.pushMatrix();
			RenderSystem.translatef(0, 0, this.depth);
			((TwoLayerStateDrawable) this.widget).drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
			RenderSystem.popMatrix();
		}
	}
}
