package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;

import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

/**
 * This class is used to draw an image on the screen that should be displayed only when a certain Screen is active.
 */
public class WidgetImage extends Widget implements TwoLayerStateDrawable {
    private ResourceLocation imageLocation;

    /**
     * The constructor takes the same parameters as it super class, in addition to a Screen. The state represents
     * the state under which the the GuiShould be for this image to be drawn. If the Gui is in another state the image
     * is not drawn.
     * @param imageLocation Resource location of the image that should be drawn
     * @param xOffset Vertical offset for the image
     * @param yOffset Horizontal offset for the image
     * @param width width of the Image (change this to resize the image)
     * @param height height of the Image (change this to resize the image)
     */
    public WidgetImage(ResourceLocation imageLocation, int xOffset, int yOffset, int width, int height) {
        super(xOffset, yOffset, width, height);
        this.imageLocation = imageLocation;
    }

    public void setImageLocation(ResourceLocation imageLocation) {
        this.imageLocation = imageLocation;
    }

    private void draw() {
        Minecraft.getInstance().getTextureManager().bindTexture(this.imageLocation);
        super.drawFullImage(
        		this.getAbsoluteXPosition(), this.getAbsoluteYPosition(), this.getWidth(), this.getHeight());
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.draw();
    }

    /**
     * this doesn't draw anything, as WidgetImages are only used for backgrounds.
     * Drawing anything might mess up with the slots no longer being on the foreground
     * @param mouseX mouse X position
     * @param mouseY mouse Y position
     */
    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
    }
}
