package computercraftsc.client.network;

import java.util.function.Supplier;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import computercraftsc.shared.network.packet.SetInventoriesLockStatePacket;
import computercraftsc.shared.network.packet.SetTurtleInventoryLockStatePacket;
import computercraftsc.shared.turtle.block.TileTurtleSC;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

/**
 * Packet handler for custom packets that are sent from the server to clients.
 * @author P.J.S. Kools
 */
public class ClientPacketHandler {
	
    private static final Logger LOGGER = LogManager.getLogger();
    
    /**
     * Handles the Server -> Client {@link SetTurtleInventoryLockStatePacket} packet.
     * Sets the turtle item inventory lock state on a turtle tile entity.
     * @param packet
     * @param ctxSupplier
     */
    public static void onSetTurtleInventoryLockStatePacketReceived(
    		SetTurtleInventoryLockStatePacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
    	NetworkEvent.Context ctx = ctxSupplier.get();
    	
    	// Ignore packets that were received on the wrong side.
    	if(ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
    		LOGGER.warn(packet.getClass().getSimpleName()
    				+ " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
    		return;
    	}
    	
    	// Mark packet as handled.
    	ctx.setPacketHandled(true);
    	
    	// Set the turtle inventory lock state.
		@SuppressWarnings("resource")
		TileEntity tileEntity = Minecraft.getInstance().world.getTileEntity(packet.turtlePos);
		if(tileEntity instanceof TileTurtleSC) {
			((TileTurtleSC) tileEntity).setTurtleInventoryLocked(packet.locked);
		}
    }
    
    /**
     * Handles the Server -> Client {@link SetInventoriesLockStatePacket} packet.
     * Sets the inventories lock state on a turtle tile entity.
     * @param packet
     * @param ctxSupplier
     */
    public static void onSetInventoriesLockStatePacketReceived(
    		SetInventoriesLockStatePacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
    	NetworkEvent.Context ctx = ctxSupplier.get();
    	
    	// Ignore packets that were received on the wrong side.
    	if(ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
    		LOGGER.warn(packet.getClass().getSimpleName()
    				+ " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
    		return;
    	}
    	
    	// Mark packet as handled.
    	ctx.setPacketHandled(true);
    	
    	// Set the inventories lock state.
		@SuppressWarnings("resource")
		TileEntity tileEntity = Minecraft.getInstance().world.getTileEntity(packet.turtlePos);
		if(tileEntity instanceof TileTurtleSC) {
			((TileTurtleSC) tileEntity).setInventoriesLocked(packet.locked);
		}
    }
}
