package computercraftsc.client.render;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;

import computercraftsc.SCGlobal;
import dan200.computercraft.client.render.TurtleSmartItemModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public final class TurtleSCModelLoader implements IModelLoader<TurtleSCModelLoader.TurtleModel> {
	
	private static final ResourceLocation COLOUR_TURTLE_MODEL =
			new ResourceLocation(SCGlobal.MOD_ID, "block/turtle_sc_color");
	
	public static final TurtleSCModelLoader INSTANCE = new TurtleSCModelLoader();
	
	private TurtleSCModelLoader() {
	}
	
	@Override
	public void onResourceManagerReload(@Nonnull IResourceManager manager) {
	}
	
	@Nonnull
	@Override
	public TurtleModel read(
			@Nonnull JsonDeserializationContext deserializationContext, @Nonnull JsonObject modelContents) {
		ResourceLocation model = new ResourceLocation(JSONUtils.getString(modelContents, "model"));
		return new TurtleModel(model);
	}
	
	public static final class TurtleModel implements IModelGeometry<TurtleModel> {
		
		private final ResourceLocation family;
		
		private TurtleModel(ResourceLocation family) {
			this.family = family;
		}
		
		@Override
		public Collection<RenderMaterial> getTextures(IModelConfiguration owner,
				Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
			Set<RenderMaterial> materials = new HashSet<>();
			materials.addAll(modelGetter.apply(this.family).getTextures(modelGetter, missingTextureErrors));
			materials.addAll(modelGetter.apply(COLOUR_TURTLE_MODEL).getTextures(modelGetter, missingTextureErrors));
			return materials;
		}
		
		@Override
		public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery,
				Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform,
				ItemOverrideList overrides, ResourceLocation modelLocation) {
			return new TurtleSmartItemModel(
					bakery.getBakedModel(this.family, transform, spriteGetter),
					bakery.getBakedModel(COLOUR_TURTLE_MODEL, transform, spriteGetter));
		}
	}
}
