package computercraftsc.client.utils;

import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;

public abstract class MouseUtils {

    public static MousePos getMousePosition() {
    	Minecraft mc = Minecraft.getInstance();
    	MainWindow mainwin = mc.getMainWindow();
    	MouseHelper mouseHelper = mc.mouseHelper;
        double mouseX = mouseHelper.getMouseX() * (double) mainwin.getScaledWidth() / (double) mainwin.getWidth();
        double mouseY = mouseHelper.getMouseY() * (double) mainwin.getScaledHeight() / (double) mainwin.getHeight();

        return new MousePos(mouseX, mouseY);
    }

    public static class MousePos {
        public final double x;
        public final double y;

        public MousePos(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}
