package computercraftsc.event;

/**
 * Represents a cancellable object.
 * @author P.J.S. Kools
 */
public interface Cancellable {

	/**
	 * Sets the cancelled flag of this object.
	 * @param cancelled - The cancelled flag.
	 */
	void setCancelled(boolean cancelled);

	/**
	 * Gets the cancelled flag of this object.
	 * @return {@code true} if the object is cancelled, {@code false} otherwise.
	 */
	boolean isCancelled();
}
