package computercraftsc.event;

import computercraftsc.shared.turtle.block.TileTurtleSC;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

/**
 * Fires when a turtle attempts a teleport (movement action). Cancelling this event will cancel the teleport.
 * @author P.J.S. Kools
 */
public class TurtleTeleportEvent extends CancellableTurtleEvent {

	private final World fromWorld;
	private final World toWorld;
	private final BlockPos fromPos;
	private final BlockPos toPos;

	public TurtleTeleportEvent(
			TileTurtleSC turtleTile, World fromWorld, BlockPos fromPos, World toWorld, BlockPos toPos) {
		super(turtleTile);
		this.fromWorld = fromWorld;
		this.fromPos = fromPos;
		this.toWorld = toWorld;
		this.toPos = toPos;
	}

	public World getFromWorld() {
		return this.fromWorld;
	}

	public World getToWorld() {
		return this.toWorld;
	}

	public BlockPos getFromPos() {
		return this.fromPos;
	}

	public BlockPos getToPos() {
		return this.toPos;
	}
}
