package computercraftsc.shared;

import computercraftsc.SCGlobal;
import computercraftsc.client.gui.container.TurtleContainerSC;
import computercraftsc.shared.items.ItemBlockName;
import computercraftsc.shared.items.ItemComment;
import computercraftsc.shared.items.ItemGuiButton;
import computercraftsc.shared.items.ItemItemName;
import computercraftsc.shared.items.ItemNumber;
import computercraftsc.shared.items.ItemProgrammingIcon;
import computercraftsc.shared.items.ItemString;
import computercraftsc.shared.items.ItemTurtleSC;
import computercraftsc.shared.items.ItemVariable;
import computercraftsc.shared.turtle.block.BlockTurtleSC;
import computercraftsc.shared.turtle.block.TileTurtleSC;
import dan200.computercraft.shared.util.FixedPointTileEntityType;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@EventBusSubscriber(modid = SCGlobal.MOD_ID, bus = EventBusSubscriber.Bus.MOD)
public class RegistrySC {
	
	private static final ItemGroup mainItemGroup = new ItemGroup(SCGlobal.MOD_ID) {
		@Override
		public ItemStack createIcon() {
			return new ItemStack(ModBlocks.TURTLE_SC.get());
		}
	};
	
	private final IEventBus eventBus;
	
	public RegistrySC(IEventBus eventBus) {
		this.eventBus = eventBus;
	}
	
	public void setup() {
		ModBlocks.BLOCKS.register(this.eventBus);
		ModTiles.TILES.register(this.eventBus);
		ModItems.ITEMS.register(this.eventBus);
		ModContainers.CONTAINERS.register(this.eventBus);
		this.eventBus.register(RegistrySC.class);
	}
	
	public static final class ModBlocks {
		
		static final DeferredRegister<Block> BLOCKS = DeferredRegister.create(ForgeRegistries.BLOCKS, SCGlobal.MOD_ID);
		
		public static final RegistryObject<BlockTurtleSC> TURTLE_SC = BLOCKS.register("turtle_sc",
				() -> new BlockTurtleSC(
						AbstractBlock.Properties.create(Material.ROCK).hardnessAndResistance(2), ModTiles.TURTLE_SC));
	}
	
	public static final class ModTiles {
		
		static final DeferredRegister<TileEntityType<?>> TILES =
				DeferredRegister.create(ForgeRegistries.TILE_ENTITIES, SCGlobal.MOD_ID);
		
		public static final RegistryObject<TileEntityType<TileTurtleSC>> TURTLE_SC =
				TILES.register(ModBlocks.TURTLE_SC.getId().getPath(),
						() -> FixedPointTileEntityType.create(ModBlocks.TURTLE_SC,
								(tileEntityType) -> new TileTurtleSC(tileEntityType)));
	}
	
	public static final class ModItems {
		
		static final DeferredRegister<Item> ITEMS = DeferredRegister.create(ForgeRegistries.ITEMS, SCGlobal.MOD_ID);
		
		public static final RegistryObject<ItemTurtleSC> TURTLE_SC =
				ITEMS.register(ModBlocks.TURTLE_SC.getId().getPath(),
						() -> new ItemTurtleSC(ModBlocks.TURTLE_SC.get(), new Item.Properties().group(mainItemGroup)));
		
		public static final RegistryObject<ItemGuiButton> BUTTON_RUN = registerGuiButton("button_run");
		public static final RegistryObject<ItemGuiButton> BUTTON_STOP = registerGuiButton("button_stop");
		public static final RegistryObject<ItemGuiButton> BUTTON_CLOSE = registerGuiButton("button_close");
		public static final RegistryObject<ItemGuiButton> BUTTON_GARBAGE = registerGuiButton("button_garbage");
		public static final RegistryObject<ItemGuiButton> BUTTON_TURTLE_INVENTORY_SCREEN = registerGuiButton("button_turtle_inventory_screen");
		public static final RegistryObject<ItemGuiButton> BUTTON_PROGRAMMING_SCREEN = registerGuiButton("button_programming_screen");
		public static final RegistryObject<ItemGuiButton> BUTTON_TERMINAL_SCREEN = registerGuiButton("button_terminal_screen");
		
		public static final RegistryObject<ItemProgrammingIcon> MOVE_FORWARD = registerProgrammingIcon("move_forward", 64);
		public static final RegistryObject<ItemProgrammingIcon> MOVE_BACK = registerProgrammingIcon("move_back", 64);
		public static final RegistryObject<ItemProgrammingIcon> TURN_LEFT = registerProgrammingIcon("turn_left", 64);
		public static final RegistryObject<ItemProgrammingIcon> TURN_RIGHT = registerProgrammingIcon("turn_right", 64);
		public static final RegistryObject<ItemProgrammingIcon> MOVE_UP = registerProgrammingIcon("move_up", 64);
		public static final RegistryObject<ItemProgrammingIcon> MOVE_DOWN = registerProgrammingIcon("move_down", 64);
		public static final RegistryObject<ItemProgrammingIcon> DIG = registerProgrammingIcon("dig", 1);
		public static final RegistryObject<ItemProgrammingIcon> DIG_UP = registerProgrammingIcon("dig_up", 1);
		public static final RegistryObject<ItemProgrammingIcon> DIG_DOWN = registerProgrammingIcon("dig_down", 1);
		public static final RegistryObject<ItemProgrammingIcon> PLACE = registerProgrammingIcon("place", 1);
		public static final RegistryObject<ItemProgrammingIcon> PLACE_UP = registerProgrammingIcon("place_up", 1);
		public static final RegistryObject<ItemProgrammingIcon> PLACE_DOWN = registerProgrammingIcon("place_down", 1);
		public static final RegistryObject<ItemProgrammingIcon> IF = registerProgrammingIcon("if", 1);
		public static final RegistryObject<ItemProgrammingIcon> THEN = registerProgrammingIcon("then", 1);
		public static final RegistryObject<ItemProgrammingIcon> END = registerProgrammingIcon("end", 1);
		public static final RegistryObject<ItemProgrammingIcon> WHILE = registerProgrammingIcon("while", 1);
		public static final RegistryObject<ItemProgrammingIcon> DO = registerProgrammingIcon("do", 1);
		public static final RegistryObject<ItemProgrammingIcon> AND = registerProgrammingIcon("and", 1);
		public static final RegistryObject<ItemProgrammingIcon> OR = registerProgrammingIcon("or", 1);
		public static final RegistryObject<ItemProgrammingIcon> ELSE = registerProgrammingIcon("else", 1);
		public static final RegistryObject<ItemProgrammingIcon> ELSE_IF = registerProgrammingIcon("else_if", 1);
		public static final RegistryObject<ItemProgrammingIcon> NOT = registerProgrammingIcon("not", 1);
		public static final RegistryObject<ItemProgrammingIcon> DETECT = registerProgrammingIcon("detect", 1);
		public static final RegistryObject<ItemProgrammingIcon> DETECT_UP = registerProgrammingIcon("detect_up", 1);
		public static final RegistryObject<ItemProgrammingIcon> DETECT_DOWN = registerProgrammingIcon("detect_down", 1);
		public static final RegistryObject<ItemProgrammingIcon> TRUE = registerProgrammingIcon("true", 1);
		public static final RegistryObject<ItemProgrammingIcon> FALSE = registerProgrammingIcon("false", 1);
		public static final RegistryObject<ItemProgrammingIcon> RANDOM_BOOLEAN = registerProgrammingIcon("random_boolean", 1);
		public static final RegistryObject<ItemProgrammingIcon> RANDOM_NUMBER = registerProgrammingIcon("random_number", 1);
		public static final RegistryObject<ItemProgrammingIcon> SELECT = registerProgrammingIcon("select", 1);
		public static final RegistryObject<ItemProgrammingIcon> DROP = registerProgrammingIcon("drop", 1);
		public static final RegistryObject<ItemProgrammingIcon> DROP_UP = registerProgrammingIcon("drop_up", 1);
		public static final RegistryObject<ItemProgrammingIcon> DROP_DOWN = registerProgrammingIcon("drop_down", 1);
		public static final RegistryObject<ItemProgrammingIcon> SUCK = registerProgrammingIcon("suck", 1);
		public static final RegistryObject<ItemProgrammingIcon> SUCK_UP = registerProgrammingIcon("suck_up", 1);
		public static final RegistryObject<ItemProgrammingIcon> SUCK_DOWN = registerProgrammingIcon("suck_down", 1);
		public static final RegistryObject<ItemProgrammingIcon> ATTACK = registerProgrammingIcon("attack", 1);
		public static final RegistryObject<ItemProgrammingIcon> ATTACK_UP = registerProgrammingIcon("attack_up", 1);
		public static final RegistryObject<ItemProgrammingIcon> ATTACK_DOWN = registerProgrammingIcon("attack_down", 1);
		public static final RegistryObject<ItemProgrammingIcon> EQUIP_LEFT = registerProgrammingIcon("equip_left", 1);
		public static final RegistryObject<ItemProgrammingIcon> EQUIP_RIGHT = registerProgrammingIcon("equip_right", 1);
		public static final RegistryObject<ItemProgrammingIcon> QUERY_REDSTONE = registerProgrammingIcon("query_redstone", 1);
		public static final RegistryObject<ItemProgrammingIcon> QUERY_REDSTONE_UP = registerProgrammingIcon("query_redstone_up", 1);
		public static final RegistryObject<ItemProgrammingIcon> QUERY_REDSTONE_DOWN = registerProgrammingIcon("query_redstone_down", 1);
		public static final RegistryObject<ItemProgrammingIcon> SET_REDSTONE = registerProgrammingIcon("set_redstone", 1);
		public static final RegistryObject<ItemProgrammingIcon> SET_REDSTONE_UP = registerProgrammingIcon("set_redstone_up", 1);
		public static final RegistryObject<ItemProgrammingIcon> SET_REDSTONE_DOWN = registerProgrammingIcon("set_redstone_down", 1);
		public static final RegistryObject<ItemProgrammingIcon> EQUAL_TO = registerProgrammingIcon("equal_to", 1);
		public static final RegistryObject<ItemProgrammingIcon> NOT_EQUAL_TO = registerProgrammingIcon("not_equal_to", 1);
		public static final RegistryObject<ItemProgrammingIcon> GREATER_THAN = registerProgrammingIcon("greater_than", 1);
		public static final RegistryObject<ItemProgrammingIcon> LESS_THAN = registerProgrammingIcon("less_than", 1);
		public static final RegistryObject<ItemProgrammingIcon> GREATER_THAN_OR_EQUAL_TO = registerProgrammingIcon("greater_than_or_equal_to", 1);
		public static final RegistryObject<ItemProgrammingIcon> LESS_THAN_OR_EQUAL_TO = registerProgrammingIcon("less_than_or_equal_to", 1);
		public static final RegistryObject<ItemProgrammingIcon> PLUS = registerProgrammingIcon("plus", 1);
		public static final RegistryObject<ItemProgrammingIcon> MINUS = registerProgrammingIcon("minus", 1);
		public static final RegistryObject<ItemProgrammingIcon> TIMES = registerProgrammingIcon("times", 1);
		public static final RegistryObject<ItemProgrammingIcon> DIVIDED_BY = registerProgrammingIcon("divided_by", 1);
		public static final RegistryObject<ItemProgrammingIcon> GET_ITEM_COUNT = registerProgrammingIcon("get_item_count", 1);
		public static final RegistryObject<ItemProgrammingIcon> FOR = registerProgrammingIcon("for", 1);
		public static final RegistryObject<ItemProgrammingIcon> REPEAT = registerProgrammingIcon("repeat", 1);
		public static final RegistryObject<ItemProgrammingIcon> BREAK = registerProgrammingIcon("break", 1);
		public static final RegistryObject<ItemProgrammingIcon> TO = registerProgrammingIcon("to", 1);
		public static final RegistryObject<ItemProgrammingIcon> COMPARE = registerProgrammingIcon("compare", 1);
		public static final RegistryObject<ItemProgrammingIcon> COMPARE_UP = registerProgrammingIcon("compare_up", 1);
		public static final RegistryObject<ItemProgrammingIcon> COMPARE_DOWN = registerProgrammingIcon("compare_down", 1);
		public static final RegistryObject<ItemProgrammingIcon> INSPECT = registerProgrammingIcon("inspect", 1);
		public static final RegistryObject<ItemProgrammingIcon> INSPECT_UP = registerProgrammingIcon("inspect_up", 1);
		public static final RegistryObject<ItemProgrammingIcon> INSPECT_DOWN = registerProgrammingIcon("inspect_down", 1);
		public static final RegistryObject<ItemProgrammingIcon> INSPECT_SLOT = registerProgrammingIcon("inspect_slot", 1);
		public static final RegistryObject<ItemProgrammingIcon> SAY = registerProgrammingIcon("say", 1);
		public static final RegistryObject<ItemProgrammingIcon> SLEEP = registerProgrammingIcon("sleep", 1);
		public static final RegistryObject<ItemProgrammingIcon> COMMENT =
				ITEMS.register("comment", () -> new ItemComment(new Item.Properties().maxStackSize(1)));
		public static final RegistryObject<ItemVariable> VARIABLE =
				ITEMS.register("variable", () -> new ItemVariable(new Item.Properties().maxStackSize(1)));
		public static final RegistryObject<ItemNumber> NUMBER =
				ITEMS.register("number", () -> new ItemNumber(new Item.Properties().maxStackSize(1)));
		public static final RegistryObject<ItemString> STRING =
				ITEMS.register("string", () -> new ItemString(new Item.Properties().maxStackSize(1)));
		public static final RegistryObject<ItemBlockName> BLOCK =
				ITEMS.register("block", () -> new ItemBlockName(new Item.Properties().maxStackSize(1)));
		public static final RegistryObject<ItemItemName> ITEM =
				ITEMS.register("item", () -> new ItemItemName(new Item.Properties().maxStackSize(1)));
		
		public static RegistryObject<ItemGuiButton> registerGuiButton(String name) {
			return ITEMS.register(name, () -> new ItemGuiButton(new Item.Properties().maxStackSize(1)));
		}
		
		public static RegistryObject<ItemProgrammingIcon> registerProgrammingIcon(String name, int maxStackSize) {
			return ITEMS.register(name, () -> new ItemProgrammingIcon(new Item.Properties().maxStackSize(maxStackSize)));
		}
	}
	
	public static final class ModContainers {
		
		static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create(ForgeRegistries.CONTAINERS, SCGlobal.MOD_ID);
		
		public static final RegistryObject<ContainerType<TurtleContainerSC>> TURTLE_CONTAINER_SC =
				CONTAINERS.register("turtle_sc",
						() -> IForgeContainerType.create(TurtleContainerSC::createContainerClientSide));
	}
}
