package computercraftsc.shared.items;

import net.minecraft.item.ItemStack;
import net.minecraft.util.text.StringTextComponent;

public class ItemNumber extends ItemProgrammingIcon {
	
	public static final int DEFAULT_NUMBER = 1;
	
	public ItemNumber(Properties properties) {
		super(properties);
	}
	
	public ItemStack create(int number) {
		ItemStack stack = new ItemStack(this, 1);
		stack.setDisplayName(new StringTextComponent(Integer.toString(number)));
		return stack;
	}
	
	/**
	 * Gets the number value.
	 * @param stack - The stack to get the number value from.
	 * @return The number value, or {@link #DEFAULT_NUMBER} if no value is set.
	 */
	public int getNumber(ItemStack stack) {
		if(stack.hasDisplayName()) {
			String number = stack.getDisplayName().getString();
			try {
				return Integer.parseInt(number);
			} catch (NumberFormatException e) {
				return DEFAULT_NUMBER;
			}
		}
		return DEFAULT_NUMBER;
	}
}
