package computercraftsc.shared.items;

import net.minecraft.item.ItemStack;
import net.minecraft.util.text.StringTextComponent;

public class ItemString extends ItemProgrammingIcon {
	
	public static final String DEFAULT_STRING = "";
	
	public ItemString(Properties properties) {
		super(properties);
	}
	
	public ItemStack create(String string) {
		ItemStack stack = new ItemStack(this);
		stack.setDisplayName(new StringTextComponent(string));
		return stack;
	}
	
	/**
	 * Gets the string value.
	 * @param stack - The stack to get the string value from.
	 * @return The string value, or {@link #DEFAULT_STRING} if no value is set.
	 */
	public String getString(ItemStack stack) {
		return (stack.hasDisplayName() ? stack.getDisplayName().getString() : DEFAULT_STRING);
	}
}
