package computercraftsc.shared.items;

import net.minecraft.item.ItemStack;
import net.minecraft.util.text.StringTextComponent;

public class ItemVariable extends ItemProgrammingIcon {
	
	public static final String DEFAULT_NAME = "x";
	
	public ItemVariable(Properties properties) {
		super(properties);
	}
	
	public ItemStack create(String name) {
		ItemStack stack = new ItemStack(this);
		stack.setDisplayName(new StringTextComponent(name));
		return stack;
	}
	
	/**
	 * Gets the variable name.
	 * @param stack - The stack to get the name from.
	 * @return The variable name, or {@link #DEFAULT_NAME} if no variable name is set.
	 */
	public String getName(ItemStack stack) {
		return (stack.hasDisplayName() ? stack.getDisplayName().getString() : DEFAULT_NAME);
	}
}
