package computercraftsc.shared.turtle.core.code.ast;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import computercraftsc.shared.RegistrySC.ModItems;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.ExpectedItemSyntaxException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import net.minecraft.item.ItemStack;

public class AssignStatement extends Statement {
	
	public String variableName;
	public Expression valExp;
	
	public AssignStatement(int codeStartIndex, int codeEndIndex, String variableName, Expression valExp) {
		super(codeStartIndex, codeEndIndex);
		this.variableName = variableName;
		this.valExp = valExp;
	}
	
	public static AssignStatement parse(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
		
		// Handle variable term.
		ItemStack variableStack = getFirstNonNullItem(code, codeIndex);
		if(variableStack == null || variableStack.getItem() != ModItems.VARIABLE.get()) {
			throw new ExpectedItemSyntaxException(ModItems.VARIABLE.get(), codeIndex.get());
		}
		String variableName = (variableStack.hasDisplayName() ? variableStack.getDisplayName().getString() : null);
		int startIndex = codeIndex.get();
		
		// Handle "=" term.
		codeIndex.incrementAndGet();
		ItemStack equalsStack = getFirstNonNullItem(code, codeIndex);
		if(equalsStack == null || equalsStack.getItem() != ModItems.EQUAL_TO.get()) {
			throw new ExpectedItemSyntaxException(ModItems.EQUAL_TO.get(), codeIndex.get());
		}
		
		// Handle expression term.
		codeIndex.incrementAndGet();
		Expression valExp = Expression.parse(code, codeIndex);
		
		// Return the result.
		return new AssignStatement(startIndex, valExp.getCodeEndIndex(), variableName, valExp);
	}
	
	@Override
	public String toCodeString() {
		return this.variableName + " = " + this.valExp.toCodeString() + ";";
	}
	
	@Override
	public ClassType typecheck(List<CompileException> compileExceptions) {
		this.valExp.typecheck(compileExceptions);
		return ClassType.VOID;
	}
}
