package computercraftsc.shared.turtle.core.code.ast;

import java.util.List;

import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.type.ClassType;

public class BinaryExpression extends Expression {
	
	public BinaryOperator operator;
	public Expression leftExp;
	public Expression rightExp;
	
	public BinaryExpression(int codeStartIndex, int codeEndIndex,
			BinaryOperator operator, Expression leftExp, Expression rightExp) {
		super(codeStartIndex, codeEndIndex);
		this.operator = operator;
		this.leftExp = leftExp;
		this.rightExp = rightExp;
	}
	
	@Override
	public String toCodeString() {
		return this.leftExp.toCodeString() + " "
				+ this.operator.getRepresentation() + " " + this.rightExp.toCodeString();
	}
	
	@Override
	public ClassType typecheck(List<CompileException> compileExceptions) {
		this.requireType(this.leftExp, this.operator.getLeftArgType(), compileExceptions);
		this.requireType(this.rightExp, this.operator.getRightArgType(), compileExceptions);
		return this.operator.getReturnType();
	}
}
