package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.turtle.core.code.type.ClassType;

public enum BinaryOperator {
	OR("or", 0, ClassType.BOOLEAN, ClassType.BOOLEAN, ClassType.BOOLEAN),
	AND("and", 1, ClassType.BOOLEAN, ClassType.BOOLEAN, ClassType.BOOLEAN),
	EQUALS("==", 2, ClassType.ANY, ClassType.ANY, ClassType.BOOLEAN),
	NOT_EQUALS("!=", 2, ClassType.ANY, ClassType.ANY, ClassType.BOOLEAN),
	LT("<", 3, ClassType.INT, ClassType.INT, ClassType.BOOLEAN),
	LTE("<=", 3, ClassType.INT, ClassType.INT, ClassType.BOOLEAN),
	GT(">", 3, ClassType.INT, ClassType.INT, ClassType.BOOLEAN),
	GTE(">=", 3, ClassType.INT, ClassType.INT, ClassType.BOOLEAN),
	PLUS("+", 4, ClassType.INT, ClassType.INT, ClassType.INT),
	MINUS("-", 4, ClassType.INT, ClassType.INT, ClassType.INT),
	TIMES("*", 5, ClassType.INT, ClassType.INT, ClassType.INT),
	DIV("/", 5, ClassType.INT, ClassType.INT, ClassType.INT);
	
	private final String representation;
	private final int precedence;
	private final ClassType leftArgType;
	private final ClassType rightArgType;
	private final ClassType returnType;
	
	private BinaryOperator(String representation, int precedence,
			ClassType leftArgType, ClassType rightArgType, ClassType returnType) {
		this.representation = representation;
		this.precedence = precedence;
		this.leftArgType = leftArgType;
		this.rightArgType = rightArgType;
		this.returnType = returnType;
	}
	
	public boolean hasPrecedenceOver(BinaryOperator other) {
		return this.precedence > other.precedence;
	}
	
	public String getRepresentation() {
		return this.representation;
	}
	
	public ClassType getLeftArgType() {
		return this.leftArgType;
	}
	
	public ClassType getRightArgType() {
		return this.rightArgType;
	}
	
	public ClassType getReturnType() {
		return this.returnType;
	}
}
