package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.turtle.core.code.type.ClassType;

public enum ExprFunctionType {
	RANDOM_NUMBER("randNumber", ClassType.INT, ClassType.INT),
	RANDOM_BOOL("randBool", ClassType.BOOLEAN),
	GET_ITEM_COUNT("getItemCount", ClassType.INT),
	DETECT("detect", ClassType.BOOLEAN),
	DETECT_UP("detectUp", ClassType.BOOLEAN),
	DETECT_DOWN("detectDown", ClassType.BOOLEAN),
	COMPARE("compare", ClassType.BOOLEAN),
	COMPARE_UP("compareUp", ClassType.BOOLEAN),
	COMPARE_DOWN("compareDown", ClassType.BOOLEAN),
	INSPECT("inspect", ClassType.STRING),
	INSPECT_UP("inspectUp", ClassType.STRING),
	INSPECT_DOWN("inspectDown", ClassType.STRING),
	INSPECT_SLOT("inspectSlot", ClassType.STRING),
	QUERY_REDSTONE("queryRedstone", ClassType.BOOLEAN),
	QUERY_REDSTONE_UP("queryRedstoneUp", ClassType.BOOLEAN),
	QUERY_REDSTONE_DOWN("queryRedstoneDown", ClassType.BOOLEAN);
	
	private final String funcName;
	private final ClassType returnType;
	private final ClassType argType;
	
	private ExprFunctionType(String funcName, ClassType returnType, ClassType argType) {
		this.funcName = funcName;
		this.returnType = returnType;
		this.argType = argType;
	}
	
	private ExprFunctionType(String funcName, ClassType returnType) {
		this(funcName, returnType, null);
	}
	
	public String getFuncName() {
		return this.funcName;
	}
	
	public ClassType getReturnType() {
		return this.returnType;
	}
	
	public boolean hasArgument() {
		return this.argType != null;
	}
	
	public ClassType getArgType() {
		return this.argType;
	}
}
