package computercraftsc.shared.turtle.core.code.ast;

import java.util.List;

import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.type.ClassType;

public class IntegerConstant extends Expression {
	
	public int value;
	
	public IntegerConstant(int codeIndex, int value) {
		super(codeIndex, codeIndex);
		this.value = value;
	}
	
	@Override
	public String toCodeString() {
		return Integer.toString(this.value);
	}
	
	@Override
	public ClassType typecheck(List<CompileException> compileExceptions) {
		return ClassType.INT;
	}
}
