package computercraftsc.shared.turtle.core.code.ast;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import computercraftsc.shared.RegistrySC.ModItems;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.ExpectedItemSyntaxException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import net.minecraft.item.ItemStack;

public class RepeatStatement extends Statement {
	
	public Expression repeatExp;
	public Statements codeStmts;
	
	public RepeatStatement(int codeStartIndex, int codeEndIndex, Expression repeatExp, Statements codeStmts) {
		super(codeStartIndex, codeEndIndex);
		this.repeatExp = repeatExp;
		this.codeStmts = codeStmts;
	}
	
	public static RepeatStatement parse(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
		
		// Handle repeat term.
		ItemStack repeatStack = getFirstNonNullItem(code, codeIndex);
		if(repeatStack == null || repeatStack.getItem() != ModItems.REPEAT.get()) {
			throw new ExpectedItemSyntaxException(ModItems.REPEAT.get(), codeIndex.get());
		}
		int repeatIndex = codeIndex.get();
		
		// Handle expression term.
		codeIndex.incrementAndGet();
		Expression repeatExp = Expression.parse(code, codeIndex);
		
		// Handle do term.
		ItemStack doStack = getFirstNonNullItem(code, codeIndex);
		if(doStack == null || doStack.getItem() != ModItems.DO.get()) {
			throw new ExpectedItemSyntaxException(ModItems.DO.get(), codeIndex.get());
		}
		
		// Handle statements term.
		codeIndex.incrementAndGet();
		Statements codeStmts = Statements.parse(code, codeIndex, ModItems.END.get());
		
		// Handle end term.
		ItemStack endStack = getFirstNonNullItem(code, codeIndex);
		if(endStack == null || endStack.getItem() != ModItems.END.get()) {
			throw new ExpectedItemSyntaxException(ModItems.END.get(), codeIndex.get());
		}
		int endIndex = codeIndex.get();
		codeIndex.incrementAndGet();
		
		// Return the result.
		return new RepeatStatement(repeatIndex, endIndex, repeatExp, codeStmts);
	}
	
	@Override
	public String toCodeString() {
		return "repeat(" + this.repeatExp.toCodeString() + ") {\n\t"
				+ this.codeStmts.toCodeString().replaceAll("\n", "\n\t") + "\n}";
	}
	
	@Override
	public ClassType typecheck(List<CompileException> compileExceptions) {
		this.requireType(this.repeatExp, ClassType.INT, compileExceptions);
		this.codeStmts.typecheck(compileExceptions);
		return ClassType.VOID;
	}
}
