package computercraftsc.shared.turtle.core.code.ast;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import computercraftsc.shared.RegistrySC.ModItems;
import computercraftsc.shared.items.ItemVariable;
import computercraftsc.shared.turtle.core.code.compiler.exception.ExpectedASTTermSyntaxException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import net.minecraft.item.ItemStack;

public abstract class Statement extends ASTTerm {
	
	public Statement(int codeStartIndex, int codeEndIndex) {
		super(codeStartIndex, codeEndIndex);
	}
	
	public static Statement parse(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
		ItemStack stack = getFirstNonNullItem(code, codeIndex);
		if(stack == null) {
			throw new ExpectedASTTermSyntaxException(Statement.class, codeIndex.get());
		}
		
		// Handle repeat: "repeat" Exp "do" Stmt* "end".
		if(stack.getItem() == ModItems.REPEAT.get()) {
			return RepeatStatement.parse(code, codeIndex);
		}
		
		// Handle if.
		if(stack.getItem() == ModItems.IF.get()) {
			return IfStatement.parse(code, codeIndex);
		}
		
		// Handle while.
		if(stack.getItem() == ModItems.WHILE.get()) {
			return WhileStatement.parse(code, codeIndex);
		}
		
		// Handle for.
		if(stack.getItem() == ModItems.FOR.get()) {
			return ForStatement.parse(code, codeIndex);
		}
		
		// Handle variable assign.
		if(stack.getItem() instanceof ItemVariable) {
			return AssignStatement.parse(code, codeIndex);
		}
		
		// Handle break.
		if(stack.getItem() == ModItems.BREAK.get()) {
			return new BreakStatement(codeIndex.getAndIncrement());
		}
		
		// Handle function statements.
		if(stack.getItem() == ModItems.MOVE_FORWARD.get()) {
			return new FunctionCallStatement(
					codeIndex.getAndIncrement(), StmtFunctionType.MOVE_FORWARD, stack.getCount());
		}
		if(stack.getItem() == ModItems.MOVE_BACK.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.MOVE_BACK, stack.getCount());
		}
		if(stack.getItem() == ModItems.TURN_LEFT.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.TURN_LEFT, stack.getCount());
		}
		if(stack.getItem() == ModItems.TURN_RIGHT.get()) {
			return new FunctionCallStatement(
					codeIndex.getAndIncrement(), StmtFunctionType.TURN_RIGHT, stack.getCount());
		}
		if(stack.getItem() == ModItems.MOVE_UP.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.MOVE_UP, stack.getCount());
		}
		if(stack.getItem() == ModItems.MOVE_DOWN.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.MOVE_DOWN, stack.getCount());
		}
		if(stack.getItem() == ModItems.PLACE.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.PLACE);
		}
		if(stack.getItem() == ModItems.PLACE_UP.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.PLACE_UP);
		}
		if(stack.getItem() == ModItems.PLACE_DOWN.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.PLACE_DOWN);
		}
		if(stack.getItem() == ModItems.DIG.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DIG);
		}
		if(stack.getItem() == ModItems.DIG_UP.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DIG_UP);
		}
		if(stack.getItem() == ModItems.DIG_DOWN.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DIG_DOWN);
		}
		if(stack.getItem() == ModItems.DROP.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DROP);
		}
		if(stack.getItem() == ModItems.DROP_UP.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DROP_UP);
		}
		if(stack.getItem() == ModItems.DROP_DOWN.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DROP_DOWN);
		}
		if(stack.getItem() == ModItems.SUCK.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.SUCK);
		}
		if(stack.getItem() == ModItems.SUCK_UP.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.SUCK_UP);
		}
		if(stack.getItem() == ModItems.SUCK_DOWN.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.SUCK_DOWN);
		}
		if(stack.getItem() == ModItems.ATTACK.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.ATTACK);
		}
		if(stack.getItem() == ModItems.ATTACK_UP.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.ATTACK_UP);
		}
		if(stack.getItem() == ModItems.ATTACK_DOWN.get()) {
			return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.ATTACK_DOWN);
		}
		if(stack.getItem() == ModItems.SET_REDSTONE.get()) {
			int funcIndex = codeIndex.getAndIncrement();
			Expression exp = Expression.parse(code, codeIndex);
			return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SET_REDSTONE, exp);
		}
		if(stack.getItem() == ModItems.SET_REDSTONE_UP.get()) {
			int funcIndex = codeIndex.getAndIncrement();
			Expression exp = Expression.parse(code, codeIndex);
			return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SET_REDSTONE_UP, exp);
		}
		if(stack.getItem() == ModItems.SET_REDSTONE_DOWN.get()) {
			int funcIndex = codeIndex.getAndIncrement();
			Expression exp = Expression.parse(code, codeIndex);
			return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SET_REDSTONE_DOWN, exp);
		}
		if(stack.getItem() == ModItems.SAY.get()) {
			int funcIndex = codeIndex.getAndIncrement();
			Expression exp = Expression.parse(code, codeIndex);
			return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SAY, exp);
		}
		if(stack.getItem() == ModItems.SLEEP.get()) {
			int funcIndex = codeIndex.getAndIncrement();
			Expression exp = Expression.parse(code, codeIndex);
			return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SLEEP, exp);
		}
		if(stack.getItem() == ModItems.COMMENT.get()) {
			return new CommentStatement(
					codeIndex.getAndIncrement(), stack.hasDisplayName() ? stack.getDisplayName().getString() : null);
		}
		if(stack.getItem() == ModItems.SELECT.get()) {
			int funcIndex = codeIndex.getAndIncrement();
			Expression exp = Expression.parse(code, codeIndex);
			return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SELECT, exp);
		}
		
		// No statement found.
		throw new ExpectedASTTermSyntaxException(Statement.class, codeIndex.get());
	}
}
