package computercraftsc.shared.turtle.core.code.ast;

import java.util.List;

import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.type.ClassType;

public class Variable extends Expression {
	
	public String name;
	
	public Variable(int codeIndex, String name) {
		super(codeIndex, codeIndex);
		this.name = name;
	}
	
	@Override
	public String toCodeString() {
		return this.name;
	}
	
	@Override
	public ClassType typecheck(List<CompileException> compileExceptions) {
		return ClassType.DYN; // Until program flow analysis is done to determine variable types, typecheck in runtime.
	}
}
