package computercraftsc.shared.turtle.core.code.compiler.exception;

import net.minecraft.item.Item;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

/**
 * This {@link Exception} should be thrown when a parser fails to parse its input due to a syntax problem where a
 * specific {@link Item} is expected and not found at a known location.
 * @author P.J.S. Kools
 */
@SuppressWarnings("serial")
public class ExpectedItemSyntaxException extends SyntaxException {
	
	private final Item expectedItem;
	
	/**
	 * Generates a new {@link ExpectedItemSyntaxException} for cases where a
	 * specific {@link Item} is expected at a known location.
	 * @param expectedItem - The expected {@link Item}.
	 * @param codeIndex - The code index at which the item was expected.
	 */
	public ExpectedItemSyntaxException(Item expectedItem, int codeIndex) {
		super("Expected " + expectedItem.getTranslationKey() + " at code index " + codeIndex, codeIndex);
		this.expectedItem = expectedItem;
	}
	
	@Override
	public IFormattableTextComponent getTextComponent() {
		return new TranslationTextComponent(
				"compiler.computercraftsc.syntax_exception_expected_code_item_message__expected",
				new TranslationTextComponent(this.expectedItem.getTranslationKey()));
	}
}
