package computercraftsc.shared.turtle.core.code.compiler.exception;

/**
 * This {@link Exception} should be thrown when a parser fails to parse its input due to a syntax problem.
 * @author P.J.S. Kools
 */
@SuppressWarnings("serial")
public class SyntaxException extends CompileException {
	
	public SyntaxException(int codeIndex) {
		super(codeIndex, codeIndex);
	}
	
	public SyntaxException(String message, int codeIndex) {
		super(message, codeIndex, codeIndex);
	}
	
	public SyntaxException(Throwable cause, int codeIndex) {
		super(cause, codeIndex, codeIndex);
	}
	
	public SyntaxException(String message, Throwable cause, int codeIndex) {
		super(message, cause, codeIndex, codeIndex);
	}
}
