/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.inventories;

import computercraftsc.client.gui.container.TurtleContainerSC;
import computercraftsc.client.gui.container.slot.CodingSlot;
import computercraftsc.client.gui.container.slotmanager.InventorySlotManager;
import computercraftsc.client.gui.inventories.Inventory;
import computercraftsc.client.gui.inventories.InventoryManager;
import computercraftsc.client.gui.inventories.ProgrammingInventory;
import computercraftsc.client.gui.inventories.ToggleButtonInventory;
import computercraftsc.client.gui.inventories.config.CodeItemEntry;
import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.items.ItemProgrammingIcon;
import computercraftsc.shared.turtle.core.code.compiler.CompileResult;
import computercraftsc.shared.turtle.core.code.compiler.TurtleLangCompiler;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CodingInventory
extends Inventory {
    private final InventoryManager inventoryManager;
    private final ToggleButtonInventory playButtonInventory;
    private CompileResult compileResult = null;
    private Set<Integer> lockedInventorySlotIds = new HashSet<Integer>();

    public CodingInventory(InventoryManager inventoryManager, ToggleButtonInventory playButtonInventory) {
        super(8, 7, 160);
        this.inventoryManager = inventoryManager;
        this.playButtonInventory = playButtonInventory;
    }

    public Set<Integer> getLockedInventorySlotIds() {
        return this.lockedInventorySlotIds;
    }

    public void setLockedInventorySlotIds(Set<Integer> lockedInventorySlotIds) {
        this.lockedInventorySlotIds = lockedInventorySlotIds;
    }

    @Override
    public Slot createSlot(final int index, int xPosition, int yPosition) {
        return new CodingSlot(this, index, xPosition, yPosition){

            public void func_75218_e() {
                super.func_75218_e();
                CodingInventory.this.compileCode();
            }

            public void func_75215_d(ItemStack stack) {
                ItemStack oldStack = this.field_75224_c.func_70301_a(index);
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)oldStack)) {
                    super.func_75215_d(stack);
                }
            }
        };
    }

    public void clearFullProgram(boolean clearLockedInvSlots) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack;
            if (!clearLockedInvSlots && this.lockedInventorySlotIds.contains(i) || (itemStack = this.func_70304_b(i)).func_190926_b()) continue;
            this.inventoryManager.getProgrammingInventory().returnItemStack(itemStack);
        }
        this.compileCode();
    }

    public CompileResult getCompileResult() {
        return this.compileResult;
    }

    @Override
    public void func_174888_l() {
        super.func_174888_l();
        this.playButtonInventory.showPrimaryImage(true);
        this.compileResult = null;
    }

    @Override
    public ItemStack func_70304_b(int i) {
        ItemStack stack = this.func_70301_a(i);
        this.func_70299_a(i, ItemStack.field_190927_a);
        return stack;
    }

    public InventorySlotManager getCodingInventorySlotManager() {
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (container instanceof TurtleContainerSC) {
            return ((TurtleContainerSC)container).getSlotManager().getCodingInventorySlotManager();
        }
        return null;
    }

    public void scrollToRow(int topRow) {
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (container instanceof TurtleContainerSC) {
            ((TurtleContainerSC)container).getSlotManager().getCodingInventorySlotManager().scrollToRow(topRow);
        }
    }

    public void compileCode() {
        if (this.inventoryManager.isConfigMode()) {
            this.compileResult = null;
            return;
        }
        try {
            this.compileResult = TurtleLangCompiler.compile(this.inventory);
        }
        catch (SyntaxException e) {
            this.compileResult = new CompileResult(null, Arrays.asList(e));
        }
        boolean hasCompileErrors = !this.compileResult.getCompileExceptions().isEmpty();
        this.playButtonInventory.showPrimaryImage(!hasCompileErrors);
    }

    public boolean codeHasCompileErrors() {
        return this.compileResult == null || !this.compileResult.getCompileExceptions().isEmpty();
    }

    public void initializeConfigItems(boolean inConfigMode) {
        if (!inConfigMode) {
            return;
        }
        this.func_174888_l();
        int index = 0;
        ProgrammingInventory programmingInventory = this.inventoryManager.getProgrammingInventory();
        for (CodeItemEntry codeItemEntry : programmingInventory.getCodeItemEntries()) {
            int stackAmount;
            for (int amount = codeItemEntry.getAmount(); amount > 0 && index < this.func_70302_i_(); amount -= stackAmount) {
                stackAmount = amount > this.func_70297_j_() ? this.func_70297_j_() : amount;
                ItemStack itemStack = programmingInventory.getProgrammingIconRetriever().getItemStackFromIdAndAmount(codeItemEntry.getIconId(), stackAmount);
                this.func_70299_a(index++, itemStack);
            }
        }
    }

    public int appendStackWithSmartIndentation(ItemStack itemStack) {
        int index;
        int currentRowStartIndex;
        int lastItemIndex;
        for (lastItemIndex = this.func_70302_i_() - 1; lastItemIndex >= 0 && this.inventory[lastItemIndex].func_190926_b(); --lastItemIndex) {
        }
        if (lastItemIndex >= this.func_70302_i_() - 1 || itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemProgrammingIcon)) {
            return -1;
        }
        if (lastItemIndex == -1) {
            this.func_70299_a(0, itemStack);
            this.compileCode();
            return 0;
        }
        int currentIndentation = 0;
        for (int i = currentRowStartIndex = lastItemIndex / 8 * 8; i < lastItemIndex && this.inventory[i].func_190926_b(); ++i) {
            ++currentIndentation;
        }
        Item lastItem = this.inventory[lastItemIndex].func_77973_b();
        int nextRowStartIndex = currentRowStartIndex + 8;
        boolean shouldIncrementAfter = CodingInventory.shouldIncrementIndentAfter((ItemProgrammingIcon)lastItem);
        boolean shouldDecrementBefore = CodingInventory.shouldDecrementIndentBefore((ItemProgrammingIcon)itemStack.func_77973_b());
        boolean shouldIncrementLine = CodingInventory.shouldIncrementLineBefore((ItemProgrammingIcon)itemStack.func_77973_b()) || CodingInventory.shouldIncrementLineAfter((ItemProgrammingIcon)lastItem) || (lastItemIndex + 1) % 8 == 0 || shouldIncrementAfter || shouldDecrementBefore;
        int n = index = shouldIncrementLine ? nextRowStartIndex + currentIndentation : lastItemIndex + 1;
        if (shouldIncrementAfter != shouldDecrementBefore) {
            if (shouldIncrementAfter) {
                if ((index + 1) % 8 != 0) {
                    ++index;
                }
            } else if (currentIndentation > 0) {
                --index;
            }
        }
        if (index >= this.func_70302_i_()) {
            return -1;
        }
        this.func_70299_a(index, itemStack);
        this.compileCode();
        return index;
    }

    private static boolean shouldDecrementIndentBefore(ItemProgrammingIcon item) {
        return item == RegistrySC.ModItems.END.get() || item == RegistrySC.ModItems.ELSE_IF.get() || item == RegistrySC.ModItems.ELSE.get();
    }

    private static boolean shouldIncrementIndentAfter(ItemProgrammingIcon item) {
        return item == RegistrySC.ModItems.DO.get() || item == RegistrySC.ModItems.THEN.get() || item == RegistrySC.ModItems.ELSE.get();
    }

    private static boolean shouldIncrementLineBefore(ItemProgrammingIcon item) {
        return item == RegistrySC.ModItems.REPEAT.get() || item == RegistrySC.ModItems.WHILE.get() || item == RegistrySC.ModItems.FOR.get() || item == RegistrySC.ModItems.IF.get() || CodingInventory.shouldDecrementIndentBefore(item);
    }

    private static boolean shouldIncrementLineAfter(ItemProgrammingIcon item) {
        return item == RegistrySC.ModItems.END.get() || CodingInventory.shouldIncrementIndentAfter(item);
    }
}

