/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import computercraftsc.client.gui.widgets.IBlockSelectionListener;
import computercraftsc.client.gui.widgets.IListBoxListener;
import computercraftsc.client.gui.widgets.TextAlignment;
import computercraftsc.client.gui.widgets.WidgetContainer;
import computercraftsc.client.gui.widgets.WidgetListBox;
import computercraftsc.client.gui.widgets.WidgetPopup;
import computercraftsc.client.gui.widgets.WidgetTextBox;
import computercraftsc.client.gui.widgets.WidgetTextButton;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;

public class WidgetBlockSelectionPopup
extends WidgetPopup {
    public static final int MATCHING_BLOCKS_LIMIT = 128;
    private IBlockSelectionListener m_listener;
    private WidgetTextBox m_textBox;
    private WidgetListBox m_listBox;
    private ArrayList<Block> m_matchingBlocks;

    public WidgetBlockSelectionPopup(int x, int y, Block defaultBlock, IBlockSelectionListener listener) {
        super(x, y, 180, 18);
        this.m_listener = listener;
        this.m_matchingBlocks = new ArrayList();
        WidgetContainer content = this.getContent();
        final WidgetTextButton okButton = new WidgetTextButton("gui.computercraftsc:popup_ok", content.getWidth() - 24, 0, 24, button -> this.tryConfirm());
        content.addWidget(okButton);
        this.m_textBox = new WidgetTextBox(this.getBlockName(defaultBlock), 32, TextAlignment.LEFT, 0, 0, content.getWidth() - 24 - 2, new WidgetTextBox.ITextBoxListener(){

            @Override
            public void onTextChanged(WidgetTextBox widget) {
                this.refresh(widget);
            }

            @Override
            public void onFocusChanged(WidgetTextBox widget) {
                this.refresh(widget);
            }

            @Override
            public boolean isTextValid(String text) {
                return true;
            }

            private void refresh(WidgetTextBox widget) {
                if (widget.getFocus()) {
                    WidgetBlockSelectionPopup.this.findMatchingBlocks(true);
                    okButton.setLocked(WidgetBlockSelectionPopup.this.m_listBox.getSelection() < 0);
                }
            }
        });
        content.addWidget(this.m_textBox);
        this.m_listBox = new WidgetListBox(0, this.m_textBox.getRelYPosition() + this.m_textBox.getHeight() + 2, content.getWidth(), 7, new String[0], new IListBoxListener(){

            @Override
            public void onSelectionChanged(WidgetListBox widget) {
                this.refresh(widget);
            }

            @Override
            public void onFocusChanged(WidgetListBox widget) {
                this.refresh(widget);
            }

            private void refresh(WidgetListBox widget) {
                String selectedText;
                okButton.setLocked(widget.getSelection() < 0);
                if (!WidgetBlockSelectionPopup.this.m_textBox.getFocus() && (selectedText = widget.getSelectedText()) != null) {
                    WidgetBlockSelectionPopup.this.m_textBox.setText(selectedText);
                }
            }
        }, true);
        content.addWidget(this.m_listBox);
        this.resizeContent(this.m_listBox.getWidth(), this.m_listBox.getRelYPosition() + this.m_listBox.getHeight());
        this.findMatchingBlocks(defaultBlock != null);
        if (defaultBlock != null) {
            for (int i = 0; i < this.m_matchingBlocks.size(); ++i) {
                if (this.m_matchingBlocks.get(i) != defaultBlock) continue;
                this.m_listBox.setSelection(i);
                break;
            }
        }
        okButton.setLocked(this.m_listBox.getSelection() < 0);
        this.m_textBox.setFocus(true);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            if (this.m_textBox.getFocus()) {
                this.m_textBox.setFocus(false);
                this.m_listBox.setFocus(true);
                if (this.m_listBox.getSelection() < 0 && this.m_matchingBlocks.size() > 0) {
                    this.m_listBox.setSelection(0);
                    this.m_textBox.setText(this.m_listBox.getSelectedText());
                }
            } else if (this.m_listBox.getFocus()) {
                this.m_listBox.setFocus(false);
                this.m_textBox.setFocus(true);
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected void onCancel() {
        this.m_listener.onCancel(this);
    }

    @Override
    protected void onConfirm() {
        if (this.tryConfirm()) {
            this.playClickSound();
        }
    }

    private boolean tryConfirm() {
        Block selectedBlock = this.getSelectedBlock();
        if (selectedBlock != null) {
            this.m_listener.onConfirmation(this, selectedBlock);
            return true;
        }
        return false;
    }

    private Block getSelectedBlock() {
        int selection = this.m_listBox.getSelection();
        if (selection >= 0) {
            return this.m_matchingBlocks.get(selection);
        }
        return null;
    }

    private String getBlockName(Block block) {
        if (block != null) {
            return new TranslationTextComponent(block.func_149739_a()).getString();
        }
        return "";
    }

    private void findMatchingBlocks(boolean selectFirstMatch) {
        this.m_matchingBlocks.clear();
        int match = -1;
        int i = 0;
        String filter = this.m_textBox.getText().toLowerCase();
        for (Block block : Registry.field_212618_g) {
            String name;
            if (block == null || !(name = this.getBlockName(block).toLowerCase()).contains(filter)) continue;
            this.m_matchingBlocks.add(block);
            if (name.equals(filter)) {
                match = i;
            }
            ++i;
            if (this.m_matchingBlocks.size() < 128) continue;
            break;
        }
        if (match < 0 && this.m_matchingBlocks.size() > 0) {
            match = 0;
        }
        String[] names = new String[this.m_matchingBlocks.size()];
        for (int j = 0; j < names.length; ++j) {
            Block block = this.m_matchingBlocks.get(j);
            names[j] = this.getBlockName(block);
        }
        this.m_listBox.setOptions(names);
        if (selectFirstMatch) {
            this.m_listBox.setSelection(match);
        }
    }
}

