/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import computercraftsc.SCGlobal;
import computercraftsc.client.gui.TurtleInventoryScreen;
import computercraftsc.client.gui.container.slotmanager.SlotManager;
import computercraftsc.client.gui.inventories.InventoryManager;
import computercraftsc.client.gui.widgets.CodingWidget;
import computercraftsc.client.gui.widgets.ProgrammingWidget;
import computercraftsc.client.gui.widgets.ScrollPaneWidget;
import computercraftsc.client.gui.widgets.TerminalWidget;
import computercraftsc.client.gui.widgets.TextWidget;
import computercraftsc.client.gui.widgets.TwoLayerStateDrawable;
import computercraftsc.client.gui.widgets.Widget;
import computercraftsc.client.gui.widgets.WidgetContainer;
import computercraftsc.client.gui.widgets.WidgetDepthWrapper;
import computercraftsc.client.gui.widgets.WidgetImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WidgetManager
implements TwoLayerStateDrawable {
    private final int guiLeft;
    private final int guiTop;
    private final Map<TurtleInventoryScreen, WidgetContainer> containers = new HashMap<TurtleInventoryScreen, WidgetContainer>();
    private final InventoryManager inventoryManager;
    private final SlotManager slotManager;
    private TurtleInventoryScreen screen;

    public WidgetManager(int guiLeft, int guiTop, InventoryManager inventoryManager, SlotManager slotManager) {
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.inventoryManager = inventoryManager;
        this.slotManager = slotManager;
        this.setupProgrammingScreenWidgets();
        this.setupInventoryScreenWidgets();
        this.setupTerminalScreenWidgets();
        this.setGuiScreen(TurtleInventoryScreen.PROGRAMMING_SCREEN);
    }

    private void setupProgrammingScreenWidgets() {
        CodingWidget codingWidget = new CodingWidget(0, 0, 144, 126, this.inventoryManager.getCodingInventory());
        ScrollPaneWidget codingContainerWidget = new ScrollPaneWidget(8, 26, 144, 126, codingWidget);
        ProgrammingWidget programmingWidget = new ProgrammingWidget(0, 0, 72, 126, this.inventoryManager);
        ScrollPaneWidget programmingContainerWidget = new ScrollPaneWidget(170, 26, 72, 126, programmingWidget);
        WidgetImage tabIndicatorWidget = new WidgetImage(SCGlobal.STATE_TAB_TEXTURE, 0, 165, 28, 27);
        WidgetImage garbageBtnBackgroundWidget = new WidgetImage(SCGlobal.EMPTY_SLOT_TEXTURE, 199, 167, 18, 18);
        WidgetImage runBtnBackgroundWidget = new WidgetImage(SCGlobal.EMPTY_SLOT_TEXTURE, 230, 167, 18, 18);
        TextWidget codingTextWidget = new TextWidget(I18n.func_135052_a((String)"gui.computercraftsc:code", (Object[])new Object[0]), 8, 17);
        TextWidget programmingTextWidget = new TextWidget(I18n.func_135052_a((String)"gui.computercraftsc:given_items", (Object[])new Object[0]), 170, 17);
        ArrayList<Widget> programmingWidgets = new ArrayList<Widget>();
        programmingWidgets.add(codingContainerWidget);
        programmingWidgets.add(programmingContainerWidget);
        programmingWidgets.add(tabIndicatorWidget);
        programmingWidgets.add(garbageBtnBackgroundWidget);
        programmingWidgets.add(runBtnBackgroundWidget);
        programmingWidgets.add(codingTextWidget);
        programmingWidgets.add(programmingTextWidget);
        this.containers.put(TurtleInventoryScreen.PROGRAMMING_SCREEN, new WidgetContainer(this.guiLeft, this.guiTop, 256, 192, programmingWidgets));
    }

    private void setupInventoryScreenWidgets() {
        ArrayList<Widget> inventoryWidgets = new ArrayList<Widget>();
        WidgetImage playerInventoryWidget = new WidgetImage(SCGlobal.PLAYER_INVENTORY_GRID_TEXTURE, 8, 26, 162, 78);
        inventoryWidgets.add(playerInventoryWidget);
        WidgetImage turtleInventoryWidget = new WidgetImage(SCGlobal.TURTLE_INVENTORY_GRID_TEXTURE, 178, 26, 72, 72);
        inventoryWidgets.add(turtleInventoryWidget);
        WidgetImage tabIndicatorWidget = new WidgetImage(SCGlobal.STATE_TAB_TEXTURE, 27, 165, 28, 27);
        inventoryWidgets.add(tabIndicatorWidget);
        WidgetImage runBtnBackgroundWidget = new WidgetImage(SCGlobal.EMPTY_SLOT_TEXTURE, 230, 167, 18, 18);
        inventoryWidgets.add(runBtnBackgroundWidget);
        TextWidget playerInventoryTextWidget = new TextWidget(I18n.func_135052_a((String)"gui.computercraftsc:player_inventory", (Object[])new Object[0]), 8, 17);
        inventoryWidgets.add(playerInventoryTextWidget);
        TextWidget turtleInventoryTextWidget = new TextWidget(I18n.func_135052_a((String)"gui.computercraftsc:robot_inventory", (Object[])new Object[0]), 178, 17);
        inventoryWidgets.add(turtleInventoryTextWidget);
        int textOffsetInSlot = 2;
        int slotIdLabelColor = 16434974;
        for (int y = 0; y < 4; ++y) {
            int yText = 28 + y * 18;
            for (int x = 0; x < 4; ++x) {
                int xText = 180 + x * 18;
                inventoryWidgets.add(new WidgetDepthWrapper(new TextWidget(Integer.toString(x + y * 4), xText, yText, 16434974), 300));
            }
        }
        this.containers.put(TurtleInventoryScreen.INVENTORY_SCREEN, new WidgetContainer(this.guiLeft, this.guiTop, 256, 192, inventoryWidgets));
    }

    private void setupTerminalScreenWidgets() {
        TerminalWidget terminalWidget = new TerminalWidget(0, 0, 220, 126, this.inventoryManager.getCodingInventory());
        ScrollPaneWidget terminalContainerWidget = new ScrollPaneWidget(8, 26, 220, 126, terminalWidget);
        WidgetImage tabIndicatorWidget = new WidgetImage(SCGlobal.STATE_TAB_TEXTURE, 54, 165, 28, 27);
        WidgetImage runBtnBackgroundWidget = new WidgetImage(SCGlobal.EMPTY_SLOT_TEXTURE, 230, 167, 18, 18);
        TextWidget terminalTextWidget = new TextWidget(I18n.func_135052_a((String)"gui.computercraftsc:code", (Object[])new Object[0]), 8, 17);
        ArrayList<Widget> terminalWidgets = new ArrayList<Widget>();
        terminalWidgets.add(terminalContainerWidget);
        terminalWidgets.add(tabIndicatorWidget);
        terminalWidgets.add(runBtnBackgroundWidget);
        terminalWidgets.add(terminalTextWidget);
        this.containers.put(TurtleInventoryScreen.TERMINAL_SCREEN, new WidgetContainer(this.guiLeft, this.guiTop, 256, 192, terminalWidgets));
    }

    public void setGuiScreen(TurtleInventoryScreen newScreen) {
        if (this.screen == newScreen) {
            return;
        }
        this.screen = newScreen;
        this.slotManager.updateSlotVisibility(newScreen);
        for (WidgetContainer container : this.containers.values()) {
            container.setVisible(false);
        }
        this.containers.get((Object)newScreen).setVisible(true);
    }

    public TurtleInventoryScreen getScreen() {
        return this.screen;
    }

    public WidgetContainer getActiveWidgetContainer() {
        return this.containers.get((Object)this.screen);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.containers.get((Object)this.screen).drawGuiContainerBackgroundLayer(matrixStack, mouseX, mouseY);
    }

    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.containers.get((Object)this.screen).drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
    }
}

