/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import computercraftsc.client.gui.widgets.TextAlignment;
import computercraftsc.client.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;

public class WidgetTextBox
extends Widget {
    public static final ResourceLocation WIDGETS_RESOURCE_LOCATION = new ResourceLocation("computercraftsc".toLowerCase(), "textures/gui/widgets.png");
    private String text;
    private int maxTextLength;
    private TextAlignment textAlignment;
    private boolean isFocussed;
    private int cursorPos;
    private ITextBoxListener textBoxListener;
    private boolean cursorBlinkState = false;
    private int cursorBlinkTickCounter = 0;
    private static final int CURSOR_BLINK_DURATION_TICKS = 8;

    public WidgetTextBox(String text, int maximumTextLength, TextAlignment alignment, int x, int y, int width, ITextBoxListener listener) {
        super(x, y, width, 18);
        this.maxTextLength = maximumTextLength;
        this.text = this.clip(text);
        this.textAlignment = alignment;
        this.isFocussed = false;
        this.cursorPos = this.text.length();
        this.textBoxListener = listener;
    }

    public void setText(String text) {
        if (!text.equals(this.text)) {
            this.text = this.clip(text);
            this.cursorPos = Math.min(this.cursorPos, this.text.length());
            this.notifyTextChanged();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setFocus(boolean focus) {
        if (this.isFocussed != focus) {
            this.isFocussed = focus;
            this.notifyFocusChanged();
        }
    }

    public boolean getFocus() {
        return this.isFocussed;
    }

    public boolean isTextValid() {
        return this.textBoxListener.isTextValid(this.text);
    }

    @Override
    public void tick() {
        if (this.cursorBlinkTickCounter++ >= 8) {
            this.cursorBlinkState = !this.cursorBlinkState;
            this.cursorBlinkTickCounter = 0;
        }
        super.tick();
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
        if (mouseX >= 0 && mouseX < this.getWidth() && mouseY >= 0 && mouseY < this.getHeight()) {
            int cursor;
            this.setFocus(true);
            int textStart = this.textAlignment == TextAlignment.LEFT ? 3 : (this.getWidth() - this.getStringWidth(this.text)) / 2;
            int localX = mouseX - textStart;
            for (cursor = 0; cursor < this.text.length() && localX >= this.getStringWidth(this.text.substring(0, cursor + 1)) - 1; ++cursor) {
            }
            this.cursorPos = cursor;
            return true;
        }
        this.setFocus(false);
        return false;
    }

    private boolean tryAddText(String text, boolean force) {
        if (text.isEmpty()) {
            return true;
        }
        String newText = this.text.substring(0, this.cursorPos) + text + this.text.substring(this.cursorPos);
        if (force || newText.length() < this.maxTextLength && this.getStringWidth(newText) <= this.getWidth() - 6) {
            this.text = this.clip(newText);
            this.cursorPos = Math.min(this.cursorPos + text.length(), this.text.length());
            this.notifyTextChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isFocussed) {
            if (keyCode == 86 && modifiers == 2) {
                String clipboardText = Minecraft.func_71410_x().field_195559_v.func_197965_a();
                if (clipboardText != null) {
                    char ch;
                    int i;
                    for (i = 0; i < clipboardText.length(); ++i) {
                        ch = clipboardText.charAt(i);
                        if (ch != '\r' && ch != '\n') continue;
                        clipboardText = clipboardText.substring(0, i);
                        break;
                    }
                    for (i = clipboardText.length() - 1; i >= 0; --i) {
                        ch = clipboardText.charAt(i);
                        if (ch >= ' ' && ch <= '~') continue;
                        clipboardText = clipboardText.substring(0, i) + clipboardText.substring(i + 1);
                    }
                    if (this.text.length() + clipboardText.length() > this.maxTextLength) {
                        clipboardText = clipboardText.substring(0, this.maxTextLength - this.text.length());
                    }
                    for (i = clipboardText.length(); i > 0 && !this.tryAddText(clipboardText, false); --i) {
                        clipboardText = clipboardText.substring(0, i);
                    }
                }
            } else {
                switch (keyCode) {
                    case 259: {
                        if (this.cursorPos > 0) {
                            this.text = this.text.substring(0, this.cursorPos - 1) + this.text.substring(this.cursorPos);
                            --this.cursorPos;
                            this.notifyTextChanged();
                        }
                        return true;
                    }
                    case 268: {
                        this.cursorPos = 0;
                        return true;
                    }
                    case 263: {
                        if (Screen.func_231173_s_()) {
                            this.cursorPos = 0;
                        } else if (this.cursorPos > 0) {
                            --this.cursorPos;
                        }
                        return true;
                    }
                    case 262: {
                        if (Screen.func_231173_s_()) {
                            this.cursorPos = this.text.length();
                        } else if (this.cursorPos < this.text.length()) {
                            ++this.cursorPos;
                        }
                        return true;
                    }
                    case 269: {
                        this.cursorPos = this.text.length();
                        return true;
                    }
                    case 261: 
                    case 330: {
                        if (this.cursorPos < this.text.length()) {
                            this.text = this.text.substring(0, this.cursorPos) + this.text.substring(this.cursorPos + 1);
                            this.notifyTextChanged();
                        }
                        return true;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean charTyped(char ch, int modifiers) {
        if (this.isFocussed && ch >= ' ' && ch <= '~') {
            this.tryAddText(Character.toString(ch), false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(MatrixStack matrixStack, Minecraft mc, int xLeftTop, int yLeftTop, int mouseX, int mouseY) {
        mc.func_110434_K().func_110577_a(WIDGETS_RESOURCE_LOCATION);
        this.drawT3(matrixStack, xLeftTop, yLeftTop, this.getWidth(), this.getHeight(), 94, 36, 36, 18);
        String text = this.getText();
        int textColour = this.isTextValid() ? 0xFFFFFF : 0xFF5555;
        int textStartX = xLeftTop + (this.textAlignment == TextAlignment.LEFT ? 3 : (this.getWidth() - this.getStringWidth(text)) / 2);
        int textStartY = yLeftTop + 5;
        this.drawString(matrixStack, text, textStartX, textStartY, textColour);
        if (this.isFocussed) {
            int lengthBeforeCursor = this.getStringWidth(this.text.substring(0, this.cursorPos));
            if (this.cursorBlinkState) {
                if (this.cursorPos < text.length()) {
                    try {
                        this.func_238473_b_(matrixStack, textStartX + lengthBeforeCursor - 1, textStartY - 1, textStartY + 8 - 1, 0xFF191919 | textColour);
                    }
                    finally {
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                } else if (this.cursorPos == text.length()) {
                    this.drawString(matrixStack, "_", textStartX + lengthBeforeCursor, textStartY, textColour);
                }
            }
        }
    }

    private void notifyTextChanged() {
        if (this.textBoxListener != null) {
            this.textBoxListener.onTextChanged(this);
        }
    }

    private void notifyFocusChanged() {
        if (this.textBoxListener != null) {
            this.textBoxListener.onFocusChanged(this);
        }
    }

    private String clip(String text) {
        if (text.length() > this.maxTextLength) {
            return text.substring(0, this.maxTextLength);
        }
        return text;
    }

    public static interface ITextBoxListener {
        public void onTextChanged(WidgetTextBox var1);

        public void onFocusChanged(WidgetTextBox var1);

        public boolean isTextValid(String var1);
    }
}

