/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.network;

import computercraftsc.client.network.ClientPacketHandler;
import computercraftsc.server.network.ServerPacketHandler;
import computercraftsc.shared.network.packet.SetCodingSlotStackPacket;
import computercraftsc.shared.network.packet.SetInventoriesLockStatePacket;
import computercraftsc.shared.network.packet.SetTurtleInventoryLockStatePacket;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public abstract class NetworkManagerSC {
    private static SimpleChannel channel;
    private static final String CHANNEL_ID = "ccsc";
    private static final String NETWORK_PROTOCOL_VERSION = "1";

    private NetworkManagerSC() {
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("computercraftsc", CHANNEL_ID), () -> NETWORK_PROTOCOL_VERSION, protocolVersion -> NETWORK_PROTOCOL_VERSION.equals(protocolVersion), protocolVersion -> NETWORK_PROTOCOL_VERSION.equals(protocolVersion));
        int packetId = 0;
        channel.registerMessage(packetId++, SetTurtleInventoryLockStatePacket.class, SetTurtleInventoryLockStatePacket::write, SetTurtleInventoryLockStatePacket::read, ClientPacketHandler::onSetTurtleInventoryLockStatePacketReceived, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, SetInventoriesLockStatePacket.class, SetInventoriesLockStatePacket::write, SetInventoriesLockStatePacket::read, ClientPacketHandler::onSetInventoriesLockStatePacketReceived, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, SetCodingSlotStackPacket.class, SetCodingSlotStackPacket::write, SetCodingSlotStackPacket::read, ServerPacketHandler::onSetCodingSlotStackPacketReceived, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <MSG> void sendPacketToServer(MSG packet) {
        channel.sendToServer(packet);
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static <MSG> void sendPacketToPlayer(ServerPlayerEntity player, MSG packet) {
        channel.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }
}

