/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.block;

import computercraftsc.ComputerCraftSC;
import computercraftsc.client.gui.ProgrammingIconRetriever;
import computercraftsc.client.gui.container.TurtleContainerSC;
import computercraftsc.client.gui.inventories.Inventory;
import computercraftsc.client.gui.inventories.InventoryManager;
import computercraftsc.client.gui.inventories.config.CodeItemEntry;
import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.items.ItemTurtleSC;
import computercraftsc.shared.turtle.core.TurtleBrainSC;
import computercraftsc.shared.turtle.core.code.ProgramState;
import computercraftsc.shared.turtle.core.code.TurtleExecutor;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.RedstoneUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileTurtleSC
extends TileTurtle {
    private String customName = null;
    private final ProgrammingIconRetriever programmingIconRetriever = new ProgrammingIconRetriever();
    private InventoryManager inventoryManager = new InventoryManager(this.programmingIconRetriever);
    private int[] redstoneOutputPower = new int[]{0, 0, 0, 0, 0, 0};
    private boolean interactionBlocked = false;
    private boolean inventoriesLocked = false;
    private boolean turtleInventoryLocked = false;
    private WeakReference<PlayerEntity> lastUsingPlayer = new WeakReference<Object>(null);
    private TurtleExecutor turtleExecutor = ComputerCraftSC.sideRunsServer() ? new TurtleExecutor(this) : null;

    public TileTurtleSC(TileEntityType<TileTurtleSC> tileEntityType) {
        super(tileEntityType, ComputerFamily.NORMAL);
        try {
            Field brainField = TileTurtle.class.getDeclaredField("brain");
            brainField.setAccessible(true);
            brainField.set((Object)this, (Object)new TurtleBrainSC(this));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new Error(e);
        }
        try {
            Field inventoryChangedField = TileTurtle.class.getDeclaredField("inventoryChanged");
            inventoryChangedField.setAccessible(true);
            inventoryChangedField.set((Object)this, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new Error(e);
        }
    }

    private void setLastUsingPlayer(PlayerEntity player) {
        this.lastUsingPlayer = new WeakReference<PlayerEntity>(player);
        this.getInventoryManager().setInventoryPlayer(player.field_71071_by);
    }

    public PlayerEntity getLastUsingPlayer() {
        return (PlayerEntity)this.lastUsingPlayer.get();
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public TurtleExecutor getExecutor() {
        return this.turtleExecutor;
    }

    public void func_174889_b(PlayerEntity player) {
        System.out.println("[DEBUG] openInventory method called.");
    }

    public ActionResultType onActivate(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (this.field_145850_b.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (this.interactionBlocked) {
            return ActionResultType.SUCCESS;
        }
        PlayerEntity lastUsingPlayer = this.getLastUsingPlayer();
        if (lastUsingPlayer != null && lastUsingPlayer.field_71070_bA instanceof TurtleContainerSC && ((TurtleContainerSC)lastUsingPlayer.field_71070_bA).getTileTurtleSC() == this && !lastUsingPlayer.equals((Object)player) && !((ServerPlayerEntity)lastUsingPlayer).func_193105_t()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.computercraftsc.turtle_already_opened_by_other_player").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            return ActionResultType.SUCCESS;
        }
        boolean isConfigMode = this.isConfigMode(player);
        this.inventoryManager.onGUIOpen(player, isConfigMode);
        this.setLastUsingPlayer(player);
        List<CodeItemEntry> codeItemEntries = this.inventoryManager.getProgrammingInventory().getCodeItemEntries();
        Set<Integer> lockedCodeInvSlotIds = this.inventoryManager.getCodingInventory().getLockedInventorySlotIds();
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> {
            buf.func_179255_a(this.field_174879_c);
            buf.writeBoolean(isConfigMode);
            buf.writeBoolean(this.inventoriesLocked);
            buf.writeBoolean(this.turtleInventoryLocked);
            buf.writeInt(codeItemEntries.size());
            for (int i = 0; i < codeItemEntries.size(); ++i) {
                buf.func_150786_a(((CodeItemEntry)codeItemEntries.get(i)).createCompoundNBT());
            }
            buf.writeBoolean(this.inventoryManager.getProgrammingInventory().getHasInfiniteCodeItems());
            buf.writeInt(lockedCodeInvSlotIds.size());
            Iterator iterator = lockedCodeInvSlotIds.iterator();
            while (iterator.hasNext()) {
                int lockedCodeInventorySlotId = (Integer)iterator.next();
                buf.writeInt(lockedCodeInventorySlotId);
            }
        });
        return ActionResultType.SUCCESS;
    }

    public Container createMenu(int windowId, PlayerInventory playerInv, PlayerEntity player) {
        return new TurtleContainerSC(windowId, playerInv, this);
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K && this.inventoryManager.isConfigMode()) {
            this.saveNewConfig();
            this.inventoryManager.getCodingInventory().func_174888_l();
        }
    }

    private void saveNewConfig() {
        List<CodeItemEntry> newCodeItemEntries = this.inventoryManager.getNewConfigItems();
        this.inventoryManager.setCodeItemEntries(newCodeItemEntries);
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return this.inventoryManager.getSizeInventory();
    }

    public boolean func_191420_l() {
        return this.inventoryManager.isEmpty();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryManager.getStackInSlot(index);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventoryManager.removeStackFromSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_70296_d();
        return this.inventoryManager.decrStackSize(index, count);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryManager.setInventorySlotContents(index, stack);
        this.func_70296_d();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public boolean hasMoved() {
        try {
            Method hasMovedMethod = TileTurtle.class.getDeclaredMethod("hasMoved", new Class[0]);
            hasMovedMethod.setAccessible(true);
            return (Boolean)hasMovedMethod.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new Error(e);
        }
    }

    public void destroy() {
        for (Direction dir : Direction.values()) {
            RedstoneUtil.propagateRedstoneOutput((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (Direction)dir);
        }
        if (!this.hasMoved()) {
            this.unload();
        }
    }

    public int getRedstoneOutput(Direction side) {
        return this.redstoneOutputPower[side.func_176745_a()];
    }

    public void setRedstoneOutput(Direction side, int power) {
        if (power >= 0 && power < 16 && this.redstoneOutputPower[side.func_176745_a()] != power) {
            this.redstoneOutputPower[side.func_176745_a()] = power;
            RedstoneUtil.propagateRedstoneOutput((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (Direction)side);
        }
    }

    public void setRedstoneOutput(InteractDirection direction, int power) {
        this.setRedstoneOutput(direction.toWorldDir(this.getAccess()), power);
    }

    public int getRedstoneInput(Direction side) {
        return this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(side), side);
    }

    public int getRedstoneInput(InteractDirection direction) {
        return this.getRedstoneInput(direction.toWorldDir(this.getAccess()));
    }

    public void setInteractionBlocked(boolean interactionBlocked) {
        this.interactionBlocked = interactionBlocked;
    }

    public boolean getInteractionBlocked() {
        return this.interactionBlocked;
    }

    public void setInventoriesLocked(boolean lock) {
        this.inventoriesLocked = lock;
    }

    public boolean getInventoriesLocked() {
        return this.inventoriesLocked;
    }

    public void setTurtleInventoryLocked(boolean lock) {
        this.turtleInventoryLocked = lock;
    }

    public boolean getTurtleInventoryLocked() {
        return this.turtleInventoryLocked;
    }

    public ItemStack getTurtleItem() {
        ItemTurtleSC turtleItem = (ItemTurtleSC)RegistrySC.ModItems.TURTLE_SC.get();
        ITurtleUpgrade leftUpgrade = this.getAccess().getUpgrade(TurtleSide.LEFT);
        ITurtleUpgrade rightUpgrade = this.getAccess().getUpgrade(TurtleSide.RIGHT);
        int fuelLevel = 0;
        return turtleItem.create(-1, null, this.getColour(), leftUpgrade, rightUpgrade, fuelLevel, this.getOverlay());
    }

    private boolean isConfigMode(PlayerEntity player) {
        boolean pIsOp = player.func_184102_h().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
        return (pIsOp || ComputerCraftSC.isSinglePlayer()) && player.func_184614_ca().func_77973_b() == Items.field_151137_ax;
    }

    public ITextComponent func_200200_C_() {
        return new StringTextComponent(((Object)((Object)this)).getClass().getSimpleName());
    }

    public boolean func_145818_k_() {
        return this.customName != null && !"".equals(this.customName);
    }

    public ITextComponent func_200201_e() {
        return this.func_145818_k_() ? new StringTextComponent(this.customName) : this.func_200200_C_();
    }

    public ITextComponent func_145748_c_() {
        return this.func_200201_e();
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        ResourceLocation resourcelocation = TileEntityType.func_200969_a((TileEntityType)this.func_200662_C());
        if (resourcelocation == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass() + " is missing a mapping! This is a bug!");
        }
        nbt.func_74778_a("id", resourcelocation.toString());
        nbt.func_74768_a("x", this.field_174879_c.func_177958_n());
        nbt.func_74768_a("y", this.field_174879_c.func_177956_o());
        nbt.func_74768_a("z", this.field_174879_c.func_177952_p());
        if (this.getTileData().func_186856_d() != 0) {
            nbt.func_218657_a("ForgeData", (INBT)this.getTileData());
        }
        if (this.getCapabilities() != null) {
            nbt.func_218657_a("ForgeCaps", (INBT)this.serializeCaps());
        }
        ((TurtleBrainSC)this.getAccess()).writeToNBT(nbt);
        TileTurtleSC.writeInventoryToNBT("TurtleInventory", this.inventoryManager.getTurtleInventory(), nbt);
        TileTurtleSC.writeInventoryToNBT("CodingInventory", this.inventoryManager.getCodingInventory(), nbt);
        ListNBT codeItemEntriesNBT = new ListNBT();
        for (CodeItemEntry codeItemEntry : this.inventoryManager.getProgrammingInventory().getCodeItemEntries()) {
            codeItemEntriesNBT.add((Object)codeItemEntry.createCompoundNBT());
        }
        nbt.func_218657_a("AvailableCodeItems", (INBT)codeItemEntriesNBT);
        Set<Integer> lockedInvSlotIds = this.inventoryManager.getCodingInventory().getLockedInventorySlotIds();
        ArrayList<Integer> lockedInvSlotIdsList = new ArrayList<Integer>(lockedInvSlotIds);
        lockedInvSlotIdsList.sort((i1, i2) -> Integer.compare(i1, i2));
        if (!lockedInvSlotIds.isEmpty()) {
            nbt.func_197646_b("LockedCodeInvSlotIds", lockedInvSlotIdsList);
        }
        if (this.inventoryManager.getProgrammingInventory().getHasInfiniteCodeItems()) {
            nbt.func_74757_a("HasInfiniteCodeItems", true);
        }
        nbt.func_74783_a("RedstoneOutputPower", this.redstoneOutputPower);
        if (this.interactionBlocked) {
            nbt.func_74757_a("InteractionBlocked", true);
        }
        if (this.inventoriesLocked) {
            nbt.func_74757_a("InventoriesLocked", true);
        }
        if (this.turtleInventoryLocked) {
            nbt.func_74757_a("TurtleInventoryLocked", true);
        }
        if (this.turtleExecutor != null) {
            this.turtleExecutor.writeToNBT(nbt);
        }
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        return nbt;
    }

    private static void writeInventoryToNBT(String tagName, Inventory inv, CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            CompoundNBT stackTag = new CompoundNBT();
            stackTag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(stackTag);
            list.add((Object)stackTag);
        }
        nbt.func_218657_a(tagName, (INBT)list);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        int[] nArray;
        this.field_174879_c = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        if (nbt.func_74764_b("ForgeData")) {
            CompoundNBT newCustomTileData = nbt.func_74775_l("ForgeData");
            CompoundNBT customTileData = this.getTileData();
            for (String key : customTileData.func_150296_c()) {
                customTileData.func_82580_o(key);
            }
            for (String key : newCustomTileData.func_150296_c()) {
                customTileData.func_218657_a(key, newCustomTileData.func_74781_a(key));
            }
        }
        if (this.getCapabilities() != null && nbt.func_74764_b("ForgeCaps")) {
            this.deserializeCaps(nbt.func_74775_l("ForgeCaps"));
        }
        ((TurtleBrainSC)this.getAccess()).readFromNBT(nbt);
        TileTurtleSC.readInventoryFromNBT("TurtleInventory", this.inventoryManager.getTurtleInventory(), nbt);
        TileTurtleSC.readInventoryFromNBT("CodingInventory", this.inventoryManager.getCodingInventory(), nbt);
        this.inventoryManager.getCodingInventory().compileCode();
        ArrayList<CodeItemEntry> codeItemEntries = new ArrayList<CodeItemEntry>();
        ListNBT config = nbt.func_150295_c("AvailableCodeItems", 10);
        for (int i = 0; i < config.size(); ++i) {
            CompoundNBT configTag = config.func_150305_b(i);
            codeItemEntries.add(CodeItemEntry.readFromNBT(configTag));
        }
        Collections.sort(codeItemEntries);
        this.inventoryManager.setCodeItemEntries(codeItemEntries);
        int[] lockedCodeInvSlotIdsArray = nbt.func_74759_k("LockedCodeInvSlotIds");
        Set<Integer> lockedCodeInvSlotIds = this.inventoryManager.getCodingInventory().getLockedInventorySlotIds();
        for (int lockedCodeInvSlotId : lockedCodeInvSlotIdsArray) {
            lockedCodeInvSlotIds.add(lockedCodeInvSlotId);
        }
        this.inventoryManager.getProgrammingInventory().setHasInfiniteCodeItems(nbt.func_74767_n("HasInfiniteCodeItems"));
        if (nbt.func_150297_b("RedstoneOutputPower", 11)) {
            nArray = nbt.func_74759_k("RedstoneOutputPower");
        } else {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray2[4] = 0;
            nArray = nArray2;
            nArray2[5] = 0;
        }
        this.redstoneOutputPower = nArray;
        this.interactionBlocked = nbt.func_74767_n("InteractionBlocked");
        this.inventoriesLocked = nbt.func_74767_n("InventoriesLocked");
        this.turtleInventoryLocked = nbt.func_74767_n("TurtleInventoryLocked");
        if (this.turtleExecutor != null) {
            this.turtleExecutor.readFromNBT(nbt);
        }
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
    }

    private static void readInventoryFromNBT(String tagName, Inventory inv, CompoundNBT nbt) {
        if (!nbt.func_150297_b(tagName, 9)) {
            return;
        }
        ListNBT list = nbt.func_150295_c(tagName, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT stackTag = list.func_150305_b(i);
            int slot = stackTag.func_74771_c("Slot") & 0xFF;
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)stackTag);
            inv.func_70299_a(slot, stack);
        }
    }

    public void transferStateFrom(TileTurtle copy) {
        super.transferStateFrom(copy);
        TileTurtleSC tileTurtleSC = (TileTurtleSC)copy;
        this.customName = tileTurtleSC.customName;
        this.inventoryManager = tileTurtleSC.inventoryManager;
        this.redstoneOutputPower = tileTurtleSC.redstoneOutputPower;
        this.interactionBlocked = tileTurtleSC.interactionBlocked;
        this.inventoriesLocked = tileTurtleSC.inventoriesLocked;
        this.turtleInventoryLocked = tileTurtleSC.turtleInventoryLocked;
        this.lastUsingPlayer = tileTurtleSC.lastUsingPlayer;
        this.turtleExecutor = tileTurtleSC.turtleExecutor;
        if (this.turtleExecutor != null) {
            this.turtleExecutor.setTileTurtle(this);
        }
    }

    private void runProgram() {
        PlayerEntity lastUsingPlayer;
        if (this.turtleExecutor.getState() != ProgramState.RUNNING) {
            this.turtleExecutor.start();
        }
        if ((lastUsingPlayer = this.getLastUsingPlayer()) != null) {
            lastUsingPlayer.func_71053_j();
        }
    }

    public void func_73660_a() {
        if (this.turtleExecutor != null) {
            this.turtleExecutor.func_73660_a();
        }
        ((TurtleBrainSC)this.getAccess()).update();
    }

    public void onProgramStateChanged(ProgramState oldState, ProgramState newState, IFormattableTextComponent errorMessage) {
        PlayerEntity lastUsingPlayer = this.getLastUsingPlayer();
        if (newState == ProgramState.ERRORED && lastUsingPlayer != null) {
            lastUsingPlayer.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "[" + TextFormatting.DARK_AQUA + "TurtleSC" + TextFormatting.GOLD + "] " + TextFormatting.RED).func_230529_a_((ITextComponent)(errorMessage != null ? errorMessage : new StringTextComponent("null")).func_240699_a_(TextFormatting.RED)), Util.field_240973_b_);
        }
    }

    public void handlePlayButtonPress() {
        if (!(this.field_145850_b.field_72995_K || this.inventoryManager.isConfigMode() || this.inventoryManager.getCodingInventory().codeHasCompileErrors())) {
            this.runProgram();
        }
    }
}

