/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code;

import computercraftsc.event.EventManager;
import computercraftsc.event.ProgramStateChangedEvent;
import computercraftsc.shared.turtle.block.TileTurtleSC;
import computercraftsc.shared.turtle.core.code.ExecutionException;
import computercraftsc.shared.turtle.core.code.ProgramState;
import computercraftsc.shared.turtle.core.code.RuntimeTypeException;
import computercraftsc.shared.turtle.core.code.ast.AssignStatement;
import computercraftsc.shared.turtle.core.code.ast.BinaryExpression;
import computercraftsc.shared.turtle.core.code.ast.BinaryOperator;
import computercraftsc.shared.turtle.core.code.ast.BooleanConstant;
import computercraftsc.shared.turtle.core.code.ast.BreakStatement;
import computercraftsc.shared.turtle.core.code.ast.CommentStatement;
import computercraftsc.shared.turtle.core.code.ast.Expression;
import computercraftsc.shared.turtle.core.code.ast.ForStatement;
import computercraftsc.shared.turtle.core.code.ast.FunctionCallExpression;
import computercraftsc.shared.turtle.core.code.ast.FunctionCallStatement;
import computercraftsc.shared.turtle.core.code.ast.IfStatement;
import computercraftsc.shared.turtle.core.code.ast.IntegerConstant;
import computercraftsc.shared.turtle.core.code.ast.JumptoStatement;
import computercraftsc.shared.turtle.core.code.ast.Program;
import computercraftsc.shared.turtle.core.code.ast.RepeatStatement;
import computercraftsc.shared.turtle.core.code.ast.Statement;
import computercraftsc.shared.turtle.core.code.ast.Statements;
import computercraftsc.shared.turtle.core.code.ast.StringConstant;
import computercraftsc.shared.turtle.core.code.ast.UnaryExpression;
import computercraftsc.shared.turtle.core.code.ast.UnaryOperator;
import computercraftsc.shared.turtle.core.code.ast.Variable;
import computercraftsc.shared.turtle.core.code.ast.WhileStatement;
import computercraftsc.shared.turtle.core.code.compiler.CompileResult;
import computercraftsc.shared.turtle.core.code.compiler.TurtleLangCompiler;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.MoveDirection;
import dan200.computercraft.shared.turtle.core.TurnDirection;
import dan200.computercraft.shared.turtle.core.TurtleCompareCommand;
import dan200.computercraft.shared.turtle.core.TurtleDetectCommand;
import dan200.computercraft.shared.turtle.core.TurtleDropCommand;
import dan200.computercraft.shared.turtle.core.TurtleInspectCommand;
import dan200.computercraft.shared.turtle.core.TurtleMoveCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtleSuckCommand;
import dan200.computercraft.shared.turtle.core.TurtleToolCommand;
import dan200.computercraft.shared.turtle.core.TurtleTurnCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TurtleExecutor
implements ITickableTileEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TICKS_BEFORE_START = 2;
    private static final int TICKS_PER_ACTION = 8;
    private TileTurtleSC tile;
    private ProgramState state = ProgramState.STOPPED;
    private int tickCount = 0;
    private int actionDurationTicks = 8;
    private int programCounter = 0;
    private List<Statement> instructions = null;
    private Map<String, Object> variableMap = new HashMap<String, Object>();
    private static final int MAX_INSTRUCTIONS_PER_TICK = 1000;

    public TurtleExecutor(TileTurtleSC tile) {
        this.tile = tile;
    }

    public void setTileTurtle(TileTurtleSC tile) {
        this.tile = tile;
    }

    public void readFromNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("ExecutionState", 10)) {
            CompoundNBT exeComp = nbt.func_74775_l("ExecutionState");
            ProgramState state = ProgramState.valueOf(exeComp.func_74779_i("State"));
            if (state == ProgramState.RUNNING) {
                this.programCounter = exeComp.func_74762_e("ProgramCounter");
                this.tickCount = exeComp.func_74762_e("TickCount");
                this.actionDurationTicks = exeComp.func_74764_b("ActionDurationTicks") ? exeComp.func_74762_e("ActionDurationTicks") : 8;
                CompoundNBT varMapComp = exeComp.func_74775_l("VarMap");
                for (String key : varMapComp.func_150296_c()) {
                    Object val;
                    INBT nbtVal = varMapComp.func_74781_a(key);
                    if (nbtVal instanceof StringNBT) {
                        val = ((StringNBT)nbtVal).func_150285_a_();
                    } else if (nbtVal instanceof IntNBT) {
                        val = ((IntNBT)nbtVal).func_150287_d();
                    } else if (nbtVal instanceof ByteNBT) {
                        val = ((ByteNBT)nbtVal).func_150290_f() != 0;
                    } else {
                        LOGGER.warn("Found unsupported type in variable map while loading from NBT: " + nbtVal.getClass());
                        continue;
                    }
                    this.variableMap.put(key, val);
                }
                CompileResult compileResult = null;
                try {
                    compileResult = TurtleLangCompiler.compile(this.tile.getInventoryManager().getCodingInventory().getInventory());
                }
                catch (SyntaxException e) {
                    this.instructions = null;
                    this.variableMap.clear();
                }
                if (compileResult != null) {
                    this.instructions = this.compileToInstructions(compileResult.getAST());
                    if (this.programCounter < 0 || this.programCounter >= this.instructions.size()) {
                        this.instructions = null;
                        this.variableMap.clear();
                    }
                }
            }
            this.setProgramState(state);
        }
    }

    public void writeToNBT(CompoundNBT nbt) {
        CompoundNBT exeComp = new CompoundNBT();
        exeComp.func_74778_a("State", this.state.name());
        if (this.state == ProgramState.RUNNING) {
            exeComp.func_74768_a("ProgramCounter", this.programCounter);
            exeComp.func_74768_a("TickCount", this.tickCount);
            if (this.actionDurationTicks != 8) {
                exeComp.func_74768_a("ActionDurationTicks", this.actionDurationTicks);
            }
            CompoundNBT varMapComp = new CompoundNBT();
            for (Map.Entry<String, Object> entry : this.variableMap.entrySet()) {
                Object val = entry.getValue();
                if (val instanceof String) {
                    varMapComp.func_74778_a(entry.getKey(), (String)val);
                    continue;
                }
                if (val instanceof Integer) {
                    varMapComp.func_74768_a(entry.getKey(), ((Integer)val).intValue());
                    continue;
                }
                if (val instanceof Boolean) {
                    varMapComp.func_74757_a(entry.getKey(), ((Boolean)val).booleanValue());
                    continue;
                }
                LOGGER.warn("Found unsupported type in variable map while writing to NBT: " + val.getClass());
            }
            exeComp.func_218657_a("VarMap", (INBT)varMapComp);
        }
        nbt.func_218657_a("ExecutionState", (INBT)exeComp);
    }

    public ProgramState getState() {
        return this.state;
    }

    public void start() {
        CompileResult compileResult;
        if (this.state == ProgramState.RUNNING) {
            this.setProgramState(ProgramState.STOPPED);
        }
        try {
            compileResult = TurtleLangCompiler.compile(this.tile.getInventoryManager().getCodingInventory().getInventory());
        }
        catch (SyntaxException e) {
            this.instructions = null;
            this.variableMap.clear();
            return;
        }
        this.instructions = this.compileToInstructions(compileResult.getAST());
        this.variableMap.clear();
        this.programCounter = 0;
        this.tickCount = 6;
        this.setProgramState(ProgramState.RUNNING);
    }

    public void stop() {
        this.setProgramState(ProgramState.STOPPED);
    }

    private List<Statement> compileToInstructions(Program ast) {
        return this.flattenStatementBlock(ast.statements, 0);
    }

    /*
     * Could not resolve type clashes
     */
    private List<Statement> flattenStatementBlock(Statements stmts, int numLoopVars) {
        List<Statement> statements = stmts.statements;
        for (int i = 0; i < statements.size(); ++i) {
            Statement stmt = statements.get(i);
            if (stmt instanceof IfStatement) {
                Iterator<Statement> ifCodeStmt2;
                IfStatement ifStmt = (IfStatement)stmt;
                Expression cond = ifStmt.condExp;
                Statements ifCode = ifStmt.ifCodeStmts;
                Statements elseCode = ifStmt.elseCodeStmts;
                ArrayList<Integer> jumptoEndInstrIndices = new ArrayList<Integer>();
                List<Statement> ifCodeStmts = this.flattenStatementBlock(ifCode, numLoopVars);
                statements.set(i, new JumptoStatement(new UnaryExpression(-1, -1, UnaryOperator.NOT, cond), ifCodeStmts.size() + 2));
                for (Iterator<Statement> ifCodeStmt2 : ifCodeStmts) {
                    statements.add(++i, (Statement)((Object)ifCodeStmt2));
                }
                statements.add(++i, null);
                jumptoEndInstrIndices.add(i);
                if (elseCode != null) {
                    List<Statement> elseCodeStmts = this.flattenStatementBlock(elseCode, numLoopVars);
                    for (Statement elseCodeStmt : elseCodeStmts) {
                        statements.add(++i, elseCodeStmt);
                    }
                }
                int endInd = i + 1;
                ifCodeStmt2 = jumptoEndInstrIndices.iterator();
                while (ifCodeStmt2.hasNext()) {
                    int ind = (Integer)((Object)ifCodeStmt2.next());
                    statements.set(ind, new JumptoStatement(new BooleanConstant(-1, true), endInd - ind));
                }
                continue;
            }
            if (stmt instanceof BreakStatement) continue;
            if (stmt instanceof ForStatement) {
                ForStatement forStmt = (ForStatement)stmt;
                String loopVarName = forStmt.varName;
                Expression startExp = forStmt.startExp;
                Expression endExp = forStmt.endExp;
                Statements loopCode = forStmt.codeStmts;
                String incrementVarName = "LOOPVAR~" + numLoopVars++;
                statements.set(i, new AssignStatement(-1, -1, incrementVarName, new BinaryExpression(-1, -1, BinaryOperator.LTE, startExp, endExp)));
                String internalLoopVarName = "LOOPVAR~" + numLoopVars++;
                statements.add(++i, new AssignStatement(-1, -1, internalLoopVarName, startExp));
                statements.add(++i, new AssignStatement(-1, -1, loopVarName, new Variable(-1, internalLoopVarName)));
                List<Statement> loopStmts = this.flattenStatementBlock(loopCode, numLoopVars);
                int endJumpIndex = i + loopStmts.size() + 7;
                this.flattenBreakStatements(loopStmts, i + 1, endJumpIndex);
                for (Statement loopStmt : loopStmts) {
                    statements.add(++i, loopStmt);
                }
                int relEndJumpIndex = 6;
                BinaryExpression cond = new BinaryExpression(-1, -1, BinaryOperator.EQUALS, new Variable(-1, internalLoopVarName), endExp);
                statements.add(++i, new JumptoStatement(cond, relEndJumpIndex));
                statements.add(++i, new JumptoStatement(new Variable(-1, incrementVarName), 3));
                statements.add(++i, new AssignStatement(-1, -1, internalLoopVarName, new BinaryExpression(-1, -1, BinaryOperator.MINUS, new Variable(-1, internalLoopVarName), new IntegerConstant(-1, 1))));
                statements.add(++i, new JumptoStatement(new BooleanConstant(-1, true), 2));
                statements.add(++i, new AssignStatement(-1, -1, internalLoopVarName, new BinaryExpression(-1, -1, BinaryOperator.PLUS, new Variable(-1, internalLoopVarName), new IntegerConstant(-1, 1))));
                statements.add(++i, new JumptoStatement(new BooleanConstant(-1, true), -loopStmts.size() - 6));
                statements.add(++i, new AssignStatement(-1, -1, loopVarName, null));
                statements.add(++i, new AssignStatement(-1, -1, internalLoopVarName, null));
                continue;
            }
            if (stmt instanceof RepeatStatement) {
                RepeatStatement repStmt = (RepeatStatement)stmt;
                Expression countExp = repStmt.repeatExp;
                Statements loopCode = repStmt.codeStmts;
                String localLoopVarName = "LOOPVAR~" + numLoopVars++;
                statements.set(i, new AssignStatement(-1, -1, localLoopVarName, countExp));
                List<Statement> loopStmts = this.flattenStatementBlock(loopCode, numLoopVars);
                int relEndJumpIndex = loopStmts.size() + 3;
                BinaryExpression cond = new BinaryExpression(-1, -1, BinaryOperator.LTE, new Variable(-1, localLoopVarName), new IntegerConstant(-1, 0));
                statements.add(++i, new JumptoStatement(cond, relEndJumpIndex));
                int endJumpIndex = i + loopStmts.size() + 3;
                this.flattenBreakStatements(loopStmts, i + 1, endJumpIndex);
                for (Statement loopStmt : loopStmts) {
                    statements.add(++i, loopStmt);
                }
                statements.add(++i, new AssignStatement(-1, -1, localLoopVarName, new BinaryExpression(-1, -1, BinaryOperator.MINUS, new Variable(-1, localLoopVarName), new IntegerConstant(-1, 1))));
                statements.add(++i, new JumptoStatement(new BooleanConstant(-1, true), -2 - loopStmts.size()));
                continue;
            }
            if (stmt instanceof WhileStatement) {
                WhileStatement whileStmt = (WhileStatement)stmt;
                Expression cond = whileStmt.condExp;
                Statements loopCode = whileStmt.codeStmts;
                List<Statement> loopStmts = this.flattenStatementBlock(loopCode, numLoopVars);
                int relEndJumpIndex = loopStmts.size() + 2;
                statements.set(i, new JumptoStatement(new UnaryExpression(-1, -1, UnaryOperator.NOT, cond), relEndJumpIndex));
                int endJumpIndex = i + loopStmts.size() + 2;
                this.flattenBreakStatements(loopStmts, i + 1, endJumpIndex);
                for (Statement loopStmt : loopStmts) {
                    statements.add(++i, loopStmt);
                }
                statements.add(++i, new JumptoStatement(new BooleanConstant(-1, true), -1 - loopStmts.size()));
                continue;
            }
            if (stmt instanceof CommentStatement) {
                statements.remove(i--);
                continue;
            }
            if (!(stmt instanceof FunctionCallStatement)) continue;
            FunctionCallStatement funcCallStmt = (FunctionCallStatement)stmt;
            if (funcCallStmt.callAmount == 0) {
                statements.remove(i--);
                continue;
            }
            if (funcCallStmt.callAmount <= 1) continue;
            int callAmount = funcCallStmt.callAmount;
            funcCallStmt.callAmount = 1;
            for (int j = 1; j < callAmount; ++j) {
                statements.add(++i, funcCallStmt);
            }
        }
        return statements;
    }

    private void flattenBreakStatements(List<Statement> stmts, int offset, int breakGoalIndex) {
        for (int i = 0; i < stmts.size(); ++i) {
            Statement stmt = stmts.get(i);
            if (!(stmt instanceof BreakStatement)) continue;
            stmts.set(i, new JumptoStatement(new BooleanConstant(-1, true), breakGoalIndex - offset - i));
        }
    }

    public void func_73660_a() {
        if (this.state == ProgramState.RUNNING && this.tickCount++ >= this.actionDurationTicks) {
            this.tickCount -= this.actionDurationTicks;
            this.step();
        }
    }

    private void step() {
        if (this.instructions == null || this.programCounter >= this.instructions.size()) {
            this.setProgramState(ProgramState.STOPPED);
            return;
        }
        int instrsExecuted = 0;
        try {
            while (this.evalStatement(this.instructions.get(this.programCounter))) {
                if (this.programCounter >= this.instructions.size()) {
                    this.setProgramState(ProgramState.STOPPED);
                    return;
                }
                if (++instrsExecuted <= 1000) continue;
                throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.max_instructions_per_tick_exceeded_exception_message"));
            }
        }
        catch (ExecutionException e) {
            IFormattableTextComponent textComponent = e.getTextComponent();
            this.setProgramState(ProgramState.ERRORED, (IFormattableTextComponent)(textComponent != null ? textComponent : new StringTextComponent(e.getMessage())));
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.setProgramState(ProgramState.ERRORED, (IFormattableTextComponent)new StringTextComponent("Internal error: " + t.getClass().getSimpleName() + ": " + t.getMessage()));
        }
    }

    private boolean evalStatement(Statement stmt) throws RuntimeTypeException, ExecutionException {
        this.actionDurationTicks = 8;
        if (stmt instanceof FunctionCallStatement) {
            TurtleToolCommand command;
            FunctionCallStatement fcStmt = (FunctionCallStatement)stmt;
            Expression[] args = fcStmt.args;
            ++this.programCounter;
            switch (fcStmt.function) {
                case MOVE_FORWARD: {
                    command = new TurtleMoveCommand(MoveDirection.FORWARD);
                    break;
                }
                case MOVE_BACK: {
                    command = new TurtleMoveCommand(MoveDirection.BACK);
                    break;
                }
                case TURN_LEFT: {
                    command = new TurtleTurnCommand(TurnDirection.LEFT);
                    break;
                }
                case TURN_RIGHT: {
                    command = new TurtleTurnCommand(TurnDirection.RIGHT);
                    break;
                }
                case MOVE_UP: {
                    command = new TurtleMoveCommand(MoveDirection.UP);
                    break;
                }
                case MOVE_DOWN: {
                    command = new TurtleMoveCommand(MoveDirection.DOWN);
                    break;
                }
                case PLACE: {
                    command = new TurtlePlaceCommand(InteractDirection.FORWARD, null);
                    break;
                }
                case PLACE_UP: {
                    command = new TurtlePlaceCommand(InteractDirection.UP, null);
                    break;
                }
                case PLACE_DOWN: {
                    command = new TurtlePlaceCommand(InteractDirection.DOWN, null);
                    break;
                }
                case DIG: {
                    command = TurtleToolCommand.dig((InteractDirection)InteractDirection.FORWARD, (TurtleSide)TurtleSide.RIGHT);
                    break;
                }
                case DIG_UP: {
                    command = TurtleToolCommand.dig((InteractDirection)InteractDirection.UP, (TurtleSide)TurtleSide.RIGHT);
                    break;
                }
                case DIG_DOWN: {
                    command = TurtleToolCommand.dig((InteractDirection)InteractDirection.DOWN, (TurtleSide)TurtleSide.RIGHT);
                    break;
                }
                case DROP: {
                    int numItems = 64;
                    command = new TurtleDropCommand(InteractDirection.FORWARD, numItems);
                    break;
                }
                case DROP_UP: {
                    int numItems = 64;
                    command = new TurtleDropCommand(InteractDirection.UP, numItems);
                    break;
                }
                case DROP_DOWN: {
                    int numItems = 64;
                    command = new TurtleDropCommand(InteractDirection.DOWN, numItems);
                    break;
                }
                case SUCK: {
                    int numItems = 64;
                    command = new TurtleSuckCommand(InteractDirection.FORWARD, numItems);
                    break;
                }
                case SUCK_UP: {
                    int numItems = 64;
                    command = new TurtleSuckCommand(InteractDirection.UP, numItems);
                    break;
                }
                case SUCK_DOWN: {
                    int numItems = 64;
                    command = new TurtleSuckCommand(InteractDirection.DOWN, numItems);
                    break;
                }
                case ATTACK: {
                    command = TurtleToolCommand.attack((InteractDirection)InteractDirection.FORWARD, (TurtleSide)TurtleSide.RIGHT);
                    break;
                }
                case ATTACK_UP: {
                    command = TurtleToolCommand.attack((InteractDirection)InteractDirection.UP, (TurtleSide)TurtleSide.RIGHT);
                    break;
                }
                case ATTACK_DOWN: {
                    command = TurtleToolCommand.attack((InteractDirection)InteractDirection.DOWN, (TurtleSide)TurtleSide.RIGHT);
                    break;
                }
                case SET_REDSTONE: {
                    boolean powered = TurtleExecutor.requireBool(this.evalExpression(args[0]));
                    int redstonePower = powered ? 15 : 0;
                    this.tile.setRedstoneOutput(InteractDirection.FORWARD, redstonePower);
                    return false;
                }
                case SET_REDSTONE_UP: {
                    boolean powered = TurtleExecutor.requireBool(this.evalExpression(args[0]));
                    int redstonePower = powered ? 15 : 0;
                    this.tile.setRedstoneOutput(InteractDirection.UP, redstonePower);
                    return false;
                }
                case SET_REDSTONE_DOWN: {
                    boolean powered = TurtleExecutor.requireBool(this.evalExpression(args[0]));
                    int redstonePower = powered ? 15 : 0;
                    this.tile.setRedstoneOutput(InteractDirection.DOWN, redstonePower);
                    return false;
                }
                case SAY: {
                    Object textObj = this.evalExpression(args[0]);
                    String text = textObj == null ? null : textObj.toString();
                    this.tile.func_145831_w().func_73046_m().func_184103_al().func_232641_a_((ITextComponent)new TranslationTextComponent("chat.type.announcement", new Object[]{new StringTextComponent("Turtle"), new StringTextComponent(text)}), ChatType.SYSTEM, Util.field_240973_b_);
                    return false;
                }
                case SELECT: {
                    int slot = TurtleExecutor.requireInt(this.evalExpression(args[0]));
                    if (slot < 0 || slot > 15) {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.slot_number_out_of_bounds_exception_message__min_index__max_index", new Object[]{0, 15}));
                    }
                    this.tile.getAccess().setSelectedSlot(slot);
                    return true;
                }
                case SLEEP: {
                    this.actionDurationTicks = TurtleExecutor.requireInt(this.evalExpression(args[0]));
                    return false;
                }
                default: {
                    throw new RuntimeTypeException("Unsupported statement function type: " + (Object)((Object)fcStmt.function));
                }
            }
            TurtleCommandResult result = command.execute(this.tile.getAccess());
            if (!result.isSuccess()) {
                switch (result.getErrorMessage()) {
                    case "Movement obstructed": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_movement_obstructed"));
                    }
                    case "No items to drop": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_no_items_to_drop"));
                    }
                    case "No space for items": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_no_space_for_items"));
                    }
                    case "No block to inspect": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_no_block_to_inspect"));
                    }
                    case "Movement failed": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_movement_failed"));
                    }
                    case "No items to place": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_no_items_to_place"));
                    }
                    case "No items to take": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_no_items_to_take"));
                    }
                    case "Cannot place item here": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_cannot_place_item_here"));
                    }
                    case "Unbreakable block detected": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_unbreakable_block_detected"));
                    }
                    case "Cannot break block with this tool": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_cannot_break_block_with_this_tool"));
                    }
                    case "Nothing to attack here": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_nothing_to_attack_here"));
                    }
                    case "Cannot break protected block": {
                        throw new ExecutionException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.command_exception_cannot_break_protected_block"));
                    }
                }
                throw new ExecutionException((IFormattableTextComponent)new StringTextComponent(result.getErrorMessage()));
            }
            return false;
        }
        if (stmt instanceof JumptoStatement) {
            JumptoStatement jumptoStmt = (JumptoStatement)stmt;
            Object retVal = this.evalExpression(jumptoStmt.condExp);
            if (retVal instanceof Boolean) {
                boolean cond = (Boolean)retVal;
                this.programCounter += cond ? jumptoStmt.relJump : 1;
            } else {
                throw new RuntimeTypeException("Invalid jumpto condition: " + (retVal == null ? "~null" : retVal.getClass().getSimpleName()));
            }
            return true;
        }
        if (stmt instanceof AssignStatement) {
            AssignStatement assignStmt = (AssignStatement)stmt;
            if (assignStmt.valExp == null) {
                this.variableMap.remove(assignStmt.variableName);
            } else {
                Object val = this.evalExpression(assignStmt.valExp);
                if (val == null) {
                    throw new RuntimeTypeException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.cannot_assign_void_to_variables_exception_message"));
                }
                this.variableMap.put(assignStmt.variableName, val);
            }
            ++this.programCounter;
            return true;
        }
        if (stmt instanceof BreakStatement) {
            throw new Error("Unconverted break statement found during turtle execution.");
        }
        throw new ExecutionException("Unsupported statement in eval: " + stmt.getClass().getSimpleName());
    }

    private Object evalExpression(Expression expr) throws RuntimeTypeException, ExecutionException {
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fcExpr = (FunctionCallExpression)expr;
            Expression[] args = fcExpr.args;
            switch (fcExpr.function) {
                case RANDOM_NUMBER: {
                    int bound = TurtleExecutor.requireInt(this.evalExpression(args[0]));
                    return new Random().nextInt(bound);
                }
                case RANDOM_BOOL: {
                    return new Random().nextBoolean();
                }
                case GET_ITEM_COUNT: {
                    int selectedSlot = this.tile.getAccess().getSelectedSlot();
                    ItemStack stack = this.tile.getInventoryManager().getTurtleInventory().func_70301_a(selectedSlot);
                    return stack == null ? 0 : stack.func_190916_E();
                }
                case DETECT: {
                    TurtleDetectCommand command = new TurtleDetectCommand(InteractDirection.FORWARD);
                    return command.execute(this.tile.getAccess()).isSuccess();
                }
                case DETECT_UP: {
                    TurtleDetectCommand command = new TurtleDetectCommand(InteractDirection.UP);
                    return command.execute(this.tile.getAccess()).isSuccess();
                }
                case DETECT_DOWN: {
                    TurtleDetectCommand command = new TurtleDetectCommand(InteractDirection.DOWN);
                    return command.execute(this.tile.getAccess()).isSuccess();
                }
                case COMPARE: {
                    TurtleCompareCommand command = new TurtleCompareCommand(InteractDirection.FORWARD);
                    return command.execute(this.tile.getAccess()).isSuccess();
                }
                case COMPARE_UP: {
                    TurtleCompareCommand command = new TurtleCompareCommand(InteractDirection.UP);
                    return command.execute(this.tile.getAccess()).isSuccess();
                }
                case COMPARE_DOWN: {
                    TurtleCompareCommand command = new TurtleCompareCommand(InteractDirection.DOWN);
                    return command.execute(this.tile.getAccess()).isSuccess();
                }
                case INSPECT: {
                    TurtleInspectCommand command = new TurtleInspectCommand(InteractDirection.FORWARD);
                    TurtleCommandResult result = command.execute(this.tile.getAccess());
                    if (!result.isSuccess()) {
                        return "minecraft:air";
                    }
                    return (String)((Map)result.getResults()[0]).get("name");
                }
                case INSPECT_UP: {
                    TurtleInspectCommand command = new TurtleInspectCommand(InteractDirection.UP);
                    TurtleCommandResult result = command.execute(this.tile.getAccess());
                    if (!result.isSuccess()) {
                        return "minecraft:air";
                    }
                    return (String)((Map)result.getResults()[0]).get("name");
                }
                case INSPECT_DOWN: {
                    TurtleInspectCommand command = new TurtleInspectCommand(InteractDirection.DOWN);
                    TurtleCommandResult result = command.execute(this.tile.getAccess());
                    if (!result.isSuccess()) {
                        return "minecraft:air";
                    }
                    return (String)((Map)result.getResults()[0]).get("name");
                }
                case INSPECT_SLOT: {
                    int selectedSlot = this.tile.getAccess().getSelectedSlot();
                    ItemStack stack = this.tile.getInventoryManager().getTurtleInventory().func_70301_a(selectedSlot);
                    Item item = stack != null && stack.func_190916_E() > 0 ? stack.func_77973_b() : Items.field_190931_a;
                    return item.getRegistryName().func_110624_b() + ":" + item.getRegistryName().func_110623_a();
                }
                case QUERY_REDSTONE: {
                    return this.tile.getRedstoneInput(InteractDirection.FORWARD) > 0;
                }
                case QUERY_REDSTONE_UP: {
                    return this.tile.getRedstoneInput(InteractDirection.UP) > 0;
                }
                case QUERY_REDSTONE_DOWN: {
                    return this.tile.getRedstoneInput(InteractDirection.DOWN) > 0;
                }
            }
            throw new RuntimeTypeException("Unsupported expression function type: " + (Object)((Object)fcExpr.function));
        }
        if (expr instanceof BooleanConstant) {
            return ((BooleanConstant)expr).value;
        }
        if (expr instanceof IntegerConstant) {
            return ((IntegerConstant)expr).value;
        }
        if (expr instanceof StringConstant) {
            return ((StringConstant)expr).value;
        }
        if (expr instanceof Variable) {
            Variable var = (Variable)expr;
            Object val = this.variableMap.get(var.name);
            if (val == null) {
                throw new RuntimeTypeException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.undefined_variable_exception_message__variable_name"));
            }
            return val;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression binExpr = (BinaryExpression)expr;
            Object leftVal = this.evalExpression(binExpr.leftExp);
            Object rightVal = this.evalExpression(binExpr.rightExp);
            BinaryOperator operator = binExpr.operator;
            if (leftVal == null) {
                throw new RuntimeTypeException("Found a null value on the left side of " + operator.getRepresentation() + ".");
            }
            if (rightVal == null) {
                throw new RuntimeTypeException("Found a null value on the right side of " + operator.getRepresentation() + ".");
            }
            switch (operator) {
                case EQUALS: {
                    return leftVal.equals(rightVal);
                }
                case NOT_EQUALS: {
                    return !leftVal.equals(rightVal);
                }
                case LT: {
                    return TurtleExecutor.requireInt(leftVal) < TurtleExecutor.requireInt(rightVal);
                }
                case LTE: {
                    return TurtleExecutor.requireInt(leftVal) <= TurtleExecutor.requireInt(rightVal);
                }
                case GT: {
                    return TurtleExecutor.requireInt(leftVal) > TurtleExecutor.requireInt(rightVal);
                }
                case GTE: {
                    return TurtleExecutor.requireInt(leftVal) >= TurtleExecutor.requireInt(rightVal);
                }
                case PLUS: {
                    return TurtleExecutor.requireInt(leftVal) + TurtleExecutor.requireInt(rightVal);
                }
                case MINUS: {
                    return TurtleExecutor.requireInt(leftVal) - TurtleExecutor.requireInt(rightVal);
                }
                case TIMES: {
                    return TurtleExecutor.requireInt(leftVal) * TurtleExecutor.requireInt(rightVal);
                }
                case DIV: {
                    int right = TurtleExecutor.requireInt(rightVal);
                    if (right == 0) {
                        throw new RuntimeTypeException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.division_by_zero_exception_message"));
                    }
                    return TurtleExecutor.requireInt(leftVal) / right;
                }
                case AND: {
                    return TurtleExecutor.requireBool(leftVal) && TurtleExecutor.requireBool(rightVal);
                }
                case OR: {
                    return TurtleExecutor.requireBool(leftVal) || TurtleExecutor.requireBool(rightVal);
                }
            }
            throw new RuntimeTypeException("Unsupported operator in binary expression: " + operator.getRepresentation());
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression unExpr = (UnaryExpression)expr;
            Object val = this.evalExpression(unExpr.exp);
            UnaryOperator operator = unExpr.operator;
            if (val == null) {
                throw new RuntimeTypeException("Found a null value in operator " + operator.getRepresentation() + ".");
            }
            switch (operator) {
                case NOT: {
                    return !TurtleExecutor.requireBool(val);
                }
                case POSITIVE: {
                    return TurtleExecutor.requireInt(val);
                }
                case NEGATIVE: {
                    return -TurtleExecutor.requireInt(val);
                }
            }
            throw new RuntimeTypeException("Unsupported operator in unary expression: " + operator.getRepresentation());
        }
        throw new RuntimeTypeException("Unsupported expression in eval: " + expr.getClass().getSimpleName());
    }

    private void setProgramState(ProgramState state, IFormattableTextComponent errorMessage) {
        if (this.state != state) {
            this.tile.onProgramStateChanged(this.state, state, errorMessage);
            ProgramStateChangedEvent event = new ProgramStateChangedEvent(this.tile, this.state, state, errorMessage);
            EventManager.getInstance().fireProgStateChangedEvent(event);
            if (!event.isCancelled()) {
                this.state = state;
            }
        }
    }

    private void setProgramState(ProgramState state) {
        this.setProgramState(state, null);
    }

    private static int requireInt(Object obj) throws RuntimeTypeException {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new RuntimeTypeException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.type_exception_message__expected_type__actual_type", new Object[]{"Integer", obj == null ? "null" : obj.getClass().getSimpleName()}));
    }

    private static boolean requireBool(Object obj) throws RuntimeTypeException {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new RuntimeTypeException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.type_exception_message__expected_type__actual_type", new Object[]{"Boolean", obj == null ? "null" : obj.getClass().getSimpleName()}));
    }

    private static String requireString(Object obj) throws RuntimeTypeException {
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new RuntimeTypeException((IFormattableTextComponent)new TranslationTextComponent("compiler.computercraftsc.type_exception_message__expected_type__actual_type", new Object[]{"String", obj == null ? "null" : obj.getClass().getSimpleName()}));
    }
}

