/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.TypeException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.ItemStack;

public abstract class ASTTerm {
    private final int codeStartIndex;
    private final int codeEndIndex;

    public ASTTerm(int codeStartIndex, int codeEndIndex) {
        this.codeStartIndex = codeStartIndex;
        this.codeEndIndex = codeEndIndex;
    }

    public int getCodeStartIndex() {
        return this.codeStartIndex;
    }

    public int getCodeEndIndex() {
        return this.codeEndIndex;
    }

    public abstract String toCodeString();

    public abstract ClassType typecheck(List<CompileException> var1);

    protected void requireType(ASTTerm term, ClassType expectedType, List<CompileException> compileExceptions) {
        ClassType type = term.typecheck(compileExceptions);
        if (!type.isInstanceOf(expectedType) && type != ClassType.DYN && expectedType != ClassType.ANY) {
            compileExceptions.add(new TypeException(expectedType, type, term.getCodeStartIndex(), term.getCodeEndIndex()));
        }
    }

    protected static ItemStack getNextNonNullItem(List<ItemStack> code, AtomicInteger codeIndex) {
        for (int index = codeIndex.get() + 1; index < code.size(); ++index) {
            ItemStack stack = code.get(index);
            if (stack.func_190926_b()) continue;
            codeIndex.set(index);
            return stack;
        }
        return null;
    }

    protected static ItemStack getFirstNonNullItem(List<ItemStack> code, AtomicInteger codeIndex) {
        for (int index = codeIndex.get(); index < code.size(); ++index) {
            ItemStack stack = code.get(index);
            if (stack.func_190926_b()) continue;
            codeIndex.set(index);
            return stack;
        }
        return null;
    }

    protected static void skipEmptyItems(List<ItemStack> code, AtomicInteger codeIndex) {
        for (int index = codeIndex.get(); index < code.size(); ++index) {
            ItemStack stack = code.get(index);
            if (stack.func_190926_b()) continue;
            codeIndex.set(index);
            return;
        }
        codeIndex.set(code.size());
    }
}

