/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.turtle.core.code.ast.Expression;
import computercraftsc.shared.turtle.core.code.ast.Statement;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.ExpectedItemSyntaxException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class AssignStatement
extends Statement {
    public String variableName;
    public Expression valExp;

    public AssignStatement(int codeStartIndex, int codeEndIndex, String variableName, Expression valExp) {
        super(codeStartIndex, codeEndIndex);
        this.variableName = variableName;
        this.valExp = valExp;
    }

    public static AssignStatement parse(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
        ItemStack variableStack = AssignStatement.getFirstNonNullItem(code, codeIndex);
        if (variableStack == null || variableStack.func_77973_b() != RegistrySC.ModItems.VARIABLE.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.VARIABLE.get(), codeIndex.get());
        }
        String variableName = variableStack.func_82837_s() ? variableStack.func_200301_q().getString() : null;
        int startIndex = codeIndex.get();
        codeIndex.incrementAndGet();
        ItemStack equalsStack = AssignStatement.getFirstNonNullItem(code, codeIndex);
        if (equalsStack == null || equalsStack.func_77973_b() != RegistrySC.ModItems.EQUAL_TO.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.EQUAL_TO.get(), codeIndex.get());
        }
        codeIndex.incrementAndGet();
        Expression valExp = Expression.parse(code, codeIndex);
        return new AssignStatement(startIndex, valExp.getCodeEndIndex(), variableName, valExp);
    }

    @Override
    public String toCodeString() {
        return this.variableName + " = " + this.valExp.toCodeString() + ";";
    }

    @Override
    public ClassType typecheck(List<CompileException> compileExceptions) {
        this.valExp.typecheck(compileExceptions);
        return ClassType.VOID;
    }
}

