/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.items.ItemProgrammingIcon;
import computercraftsc.shared.turtle.core.code.ast.Expression;
import computercraftsc.shared.turtle.core.code.ast.Statement;
import computercraftsc.shared.turtle.core.code.ast.Statements;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.ExpectedItemSyntaxException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class IfStatement
extends Statement {
    public Expression condExp;
    public Statements ifCodeStmts;
    public Statements elseCodeStmts;

    public IfStatement(int codeStartIndex, int codeEndIndex, Expression condExp, Statements ifCodeStmts, Statements elseCodeStmts) {
        super(codeStartIndex, codeEndIndex);
        this.condExp = condExp;
        this.ifCodeStmts = ifCodeStmts;
        this.elseCodeStmts = elseCodeStmts;
    }

    public static IfStatement parse(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
        ItemStack ifStack = IfStatement.getFirstNonNullItem(code, codeIndex);
        if (ifStack == null || ifStack.func_77973_b() != RegistrySC.ModItems.IF.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.IF.get(), codeIndex.get());
        }
        int ifIndex = codeIndex.get();
        codeIndex.incrementAndGet();
        Expression condExp = Expression.parse(code, codeIndex);
        ItemStack thenStack = IfStatement.getFirstNonNullItem(code, codeIndex);
        if (thenStack == null || thenStack.func_77973_b() != RegistrySC.ModItems.THEN.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.THEN.get(), codeIndex.get());
        }
        codeIndex.incrementAndGet();
        Statements ifCodeStmts = Statements.parse(code, codeIndex, (ItemProgrammingIcon)RegistrySC.ModItems.END.get(), (ItemProgrammingIcon)RegistrySC.ModItems.ELSE_IF.get(), (ItemProgrammingIcon)RegistrySC.ModItems.ELSE.get());
        Statements elseCodeStmts = IfStatement.parseOptionalElse(code, codeIndex);
        ItemStack endStack = IfStatement.getFirstNonNullItem(code, codeIndex);
        if (endStack == null || endStack.func_77973_b() != RegistrySC.ModItems.END.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.END.get(), codeIndex.get());
        }
        int endIndex = codeIndex.get();
        codeIndex.incrementAndGet();
        return new IfStatement(ifIndex, endIndex, condExp, ifCodeStmts, elseCodeStmts);
    }

    private static Statements parseOptionalElse(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
        ItemStack stack = IfStatement.getFirstNonNullItem(code, codeIndex);
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.ELSE.get()) {
            codeIndex.incrementAndGet();
            return Statements.parse(code, codeIndex, (ItemProgrammingIcon)RegistrySC.ModItems.END.get());
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.ELSE_IF.get()) {
            int elseIfIndex = codeIndex.get();
            codeIndex.incrementAndGet();
            Expression condExp = Expression.parse(code, codeIndex);
            ItemStack thenStack = IfStatement.getFirstNonNullItem(code, codeIndex);
            if (thenStack == null || thenStack.func_77973_b() != RegistrySC.ModItems.THEN.get()) {
                throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.THEN.get(), codeIndex.get());
            }
            int thenIndex = codeIndex.get();
            codeIndex.incrementAndGet();
            Statements elseIfCodeStmts = Statements.parse(code, codeIndex, (ItemProgrammingIcon)RegistrySC.ModItems.END.get(), (ItemProgrammingIcon)RegistrySC.ModItems.ELSE_IF.get(), (ItemProgrammingIcon)RegistrySC.ModItems.ELSE.get());
            Statements elseCodeStmts = IfStatement.parseOptionalElse(code, codeIndex);
            Statements ret = new Statements();
            int codeEndIndex = elseCodeStmts != null ? elseCodeStmts.getCodeEndIndex() : (elseIfCodeStmts.getCodeEndIndex() != -1 ? elseIfCodeStmts.getCodeEndIndex() : thenIndex);
            ret.statements.add(new IfStatement(elseIfIndex, codeEndIndex, condExp, elseIfCodeStmts, elseCodeStmts));
            return ret;
        }
        return null;
    }

    @Override
    public ClassType typecheck(List<CompileException> compileExceptions) {
        this.requireType(this.condExp, ClassType.BOOLEAN, compileExceptions);
        this.ifCodeStmts.typecheck(compileExceptions);
        if (this.elseCodeStmts != null) {
            this.elseCodeStmts.typecheck(compileExceptions);
        }
        return ClassType.VOID;
    }

    @Override
    public String toCodeString() {
        return "if(" + this.condExp.toCodeString() + ") {\n\t" + this.ifCodeStmts.toCodeString().replaceAll("\n", "\n\t") + "\n}" + (this.elseCodeStmts != null ? " else {\n\t" + this.elseCodeStmts.toCodeString().replaceAll("\n", "\n\t") + "\n}" : "");
    }
}

