/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.items.ItemProgrammingIcon;
import computercraftsc.shared.turtle.core.code.ast.Expression;
import computercraftsc.shared.turtle.core.code.ast.Statement;
import computercraftsc.shared.turtle.core.code.ast.Statements;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.ExpectedItemSyntaxException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RepeatStatement
extends Statement {
    public Expression repeatExp;
    public Statements codeStmts;

    public RepeatStatement(int codeStartIndex, int codeEndIndex, Expression repeatExp, Statements codeStmts) {
        super(codeStartIndex, codeEndIndex);
        this.repeatExp = repeatExp;
        this.codeStmts = codeStmts;
    }

    public static RepeatStatement parse(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
        ItemStack repeatStack = RepeatStatement.getFirstNonNullItem(code, codeIndex);
        if (repeatStack == null || repeatStack.func_77973_b() != RegistrySC.ModItems.REPEAT.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.REPEAT.get(), codeIndex.get());
        }
        int repeatIndex = codeIndex.get();
        codeIndex.incrementAndGet();
        Expression repeatExp = Expression.parse(code, codeIndex);
        ItemStack doStack = RepeatStatement.getFirstNonNullItem(code, codeIndex);
        if (doStack == null || doStack.func_77973_b() != RegistrySC.ModItems.DO.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.DO.get(), codeIndex.get());
        }
        codeIndex.incrementAndGet();
        Statements codeStmts = Statements.parse(code, codeIndex, (ItemProgrammingIcon)RegistrySC.ModItems.END.get());
        ItemStack endStack = RepeatStatement.getFirstNonNullItem(code, codeIndex);
        if (endStack == null || endStack.func_77973_b() != RegistrySC.ModItems.END.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.END.get(), codeIndex.get());
        }
        int endIndex = codeIndex.get();
        codeIndex.incrementAndGet();
        return new RepeatStatement(repeatIndex, endIndex, repeatExp, codeStmts);
    }

    @Override
    public String toCodeString() {
        return "repeat(" + this.repeatExp.toCodeString() + ") {\n\t" + this.codeStmts.toCodeString().replaceAll("\n", "\n\t") + "\n}";
    }

    @Override
    public ClassType typecheck(List<CompileException> compileExceptions) {
        this.requireType(this.repeatExp, ClassType.INT, compileExceptions);
        this.codeStmts.typecheck(compileExceptions);
        return ClassType.VOID;
    }
}

