/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.items.ItemVariable;
import computercraftsc.shared.turtle.core.code.ast.ASTTerm;
import computercraftsc.shared.turtle.core.code.ast.AssignStatement;
import computercraftsc.shared.turtle.core.code.ast.BreakStatement;
import computercraftsc.shared.turtle.core.code.ast.CommentStatement;
import computercraftsc.shared.turtle.core.code.ast.Expression;
import computercraftsc.shared.turtle.core.code.ast.ForStatement;
import computercraftsc.shared.turtle.core.code.ast.FunctionCallStatement;
import computercraftsc.shared.turtle.core.code.ast.IfStatement;
import computercraftsc.shared.turtle.core.code.ast.RepeatStatement;
import computercraftsc.shared.turtle.core.code.ast.StmtFunctionType;
import computercraftsc.shared.turtle.core.code.ast.WhileStatement;
import computercraftsc.shared.turtle.core.code.compiler.exception.ExpectedASTTermSyntaxException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.ItemStack;

public abstract class Statement
extends ASTTerm {
    public Statement(int codeStartIndex, int codeEndIndex) {
        super(codeStartIndex, codeEndIndex);
    }

    public static Statement parse(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
        ItemStack stack = Statement.getFirstNonNullItem(code, codeIndex);
        if (stack == null) {
            throw new ExpectedASTTermSyntaxException(Statement.class, codeIndex.get());
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.REPEAT.get()) {
            return RepeatStatement.parse(code, codeIndex);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.IF.get()) {
            return IfStatement.parse(code, codeIndex);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.WHILE.get()) {
            return WhileStatement.parse(code, codeIndex);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.FOR.get()) {
            return ForStatement.parse(code, codeIndex);
        }
        if (stack.func_77973_b() instanceof ItemVariable) {
            return AssignStatement.parse(code, codeIndex);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.BREAK.get()) {
            return new BreakStatement(codeIndex.getAndIncrement());
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.MOVE_FORWARD.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.MOVE_FORWARD, stack.func_190916_E());
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.MOVE_BACK.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.MOVE_BACK, stack.func_190916_E());
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.TURN_LEFT.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.TURN_LEFT, stack.func_190916_E());
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.TURN_RIGHT.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.TURN_RIGHT, stack.func_190916_E());
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.MOVE_UP.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.MOVE_UP, stack.func_190916_E());
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.MOVE_DOWN.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.MOVE_DOWN, stack.func_190916_E());
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.PLACE.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.PLACE);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.PLACE_UP.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.PLACE_UP);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.PLACE_DOWN.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.PLACE_DOWN);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.DIG.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DIG);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.DIG_UP.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DIG_UP);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.DIG_DOWN.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DIG_DOWN);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.DROP.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DROP);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.DROP_UP.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DROP_UP);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.DROP_DOWN.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.DROP_DOWN);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.SUCK.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.SUCK);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.SUCK_UP.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.SUCK_UP);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.SUCK_DOWN.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.SUCK_DOWN);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.ATTACK.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.ATTACK);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.ATTACK_UP.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.ATTACK_UP);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.ATTACK_DOWN.get()) {
            return new FunctionCallStatement(codeIndex.getAndIncrement(), StmtFunctionType.ATTACK_DOWN);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.SET_REDSTONE.get()) {
            int funcIndex = codeIndex.getAndIncrement();
            Expression exp = Expression.parse(code, codeIndex);
            return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SET_REDSTONE, exp);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.SET_REDSTONE_UP.get()) {
            int funcIndex = codeIndex.getAndIncrement();
            Expression exp = Expression.parse(code, codeIndex);
            return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SET_REDSTONE_UP, exp);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.SET_REDSTONE_DOWN.get()) {
            int funcIndex = codeIndex.getAndIncrement();
            Expression exp = Expression.parse(code, codeIndex);
            return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SET_REDSTONE_DOWN, exp);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.SAY.get()) {
            int funcIndex = codeIndex.getAndIncrement();
            Expression exp = Expression.parse(code, codeIndex);
            return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SAY, exp);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.SLEEP.get()) {
            int funcIndex = codeIndex.getAndIncrement();
            Expression exp = Expression.parse(code, codeIndex);
            return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SLEEP, exp);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.COMMENT.get()) {
            return new CommentStatement(codeIndex.getAndIncrement(), stack.func_82837_s() ? stack.func_200301_q().getString() : null);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.SELECT.get()) {
            int funcIndex = codeIndex.getAndIncrement();
            Expression exp = Expression.parse(code, codeIndex);
            return new FunctionCallStatement(funcIndex, exp.getCodeEndIndex(), StmtFunctionType.SELECT, exp);
        }
        throw new ExpectedASTTermSyntaxException(Statement.class, codeIndex.get());
    }
}

