/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.turtle.core.code.type.ClassType;

public enum StmtFunctionType {
    MOVE_FORWARD("moveForward"),
    MOVE_BACK("moveBack"),
    TURN_LEFT("turnLeft"),
    TURN_RIGHT("turnRight"),
    MOVE_UP("moveUp"),
    MOVE_DOWN("moveDown"),
    PLACE("place"),
    PLACE_UP("placeUp"),
    PLACE_DOWN("placeDown"),
    DIG("dig"),
    DIG_UP("digUp"),
    DIG_DOWN("digDown"),
    DROP("drop"),
    DROP_UP("dropUp"),
    DROP_DOWN("dropDown"),
    SUCK("suck"),
    SUCK_UP("suckUp"),
    SUCK_DOWN("suckDown"),
    ATTACK("attack"),
    ATTACK_UP("attackUp"),
    ATTACK_DOWN("attackDown"),
    SET_REDSTONE("setRedstone", ClassType.BOOLEAN),
    SET_REDSTONE_UP("setRedstoneUp", ClassType.BOOLEAN),
    SET_REDSTONE_DOWN("setRedstoneDown", ClassType.BOOLEAN),
    SAY("say", ClassType.ANY),
    SELECT("select", ClassType.INT),
    SLEEP("sleep", ClassType.INT);

    private final String funcName;
    private final ClassType argType;

    private StmtFunctionType(String funcName, ClassType argType) {
        this.funcName = funcName;
        this.argType = argType;
    }

    private StmtFunctionType(String funcName) {
        this(funcName, null);
    }

    public String getFuncName() {
        return this.funcName;
    }

    public boolean hasArgument() {
        return this.argType != null;
    }

    public ClassType getArgType() {
        return this.argType;
    }
}

