package computercraftsc;

import java.lang.reflect.Method;

import computercraftsc.client.ClientRegistrySC;
import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.network.NetworkManagerSC;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(SCGlobal.MOD_ID)
public class ComputerCraftSC {
	
	public static ComputerCraftSC instance;
	
	public ComputerCraftSC() {
		instance = this;
		
		// Get mod event bus.
		IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
		
		// Shared setup.
		new RegistrySC(modEventBus).setup();
		
		// Register network manager.
		modEventBus.register(NetworkManagerSC.class);
		
		// Client side only setup.
		DistExecutor.safeRunWhenOn(Dist.CLIENT, () -> new ClientRegistrySC(modEventBus)::setup);
	}
	
	/**
	 * Checks whether the mod currently runs on a side that runs a server.
	 * @return Whether the mod currently runs on a side that runs a server.
	 * This is true for servers and for single player.
	 */
	public static boolean sideRunsServer() {
		
		// Return true server-sided or in single player.
		return FMLEnvironment.dist == Dist.DEDICATED_SERVER || isSinglePlayer();
	}
	
	/**
	 * Checks whether the mod currently runs in single player.
	 * @return {@code true} if the mod runs in single player, {@code false} otherwise.
	 */
	public static boolean isSinglePlayer() {
		
		// Return false server-sided.
		if(FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
			return false;
		}
		
		// Return the result of Minecraft.getInstance().isSingleplayer() client-sided.
		try {
			Class<?> mcClass = Class.forName("net.minecraft.client.Minecraft");
			Method getInstanceMethod = mcClass.getDeclaredMethod("func_71410_x");
			Object mcInstance = getInstanceMethod.invoke(null);
			Method isSinglePlayerMethod = mcClass.getDeclaredMethod("func_71356_B");
			Object result = isSinglePlayerMethod.invoke(mcInstance);
			return (Boolean) result;
		} catch (Exception e) {
			throw new Error(e);
		}
	}
}
