package computercraftsc.client;

import java.util.HashSet;
import java.util.Map;

import computercraftsc.SCGlobal;
import computercraftsc.client.gui.container.TurtleGuiContainerSC;
import computercraftsc.client.render.TileEntityTurtleSCRenderer;
import computercraftsc.client.render.TurtleSCModelLoader;
import computercraftsc.shared.RegistrySC;
import dan200.computercraft.shared.common.IColouredItem;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(Dist.CLIENT)
@EventBusSubscriber(modid = SCGlobal.MOD_ID, value = Dist.CLIENT, bus = EventBusSubscriber.Bus.MOD)
public class ClientRegistrySC {
	
	private final IEventBus eventBus;
	
	public ClientRegistrySC(IEventBus eventBus) {
		this.eventBus = eventBus;
	}
	
	public void setup() {
		this.eventBus.register(ClientRegistrySC.class);
	}
	
	@SubscribeEvent
	public static void onClientSetupEvent(FMLClientSetupEvent event) {
		
		// Register turtle container.
		ScreenManager.registerFactory(RegistrySC.ModContainers.TURTLE_CONTAINER_SC.get(), TurtleGuiContainerSC::new);
		
		// Register turtle renderer.
		RenderTypeLookup.setRenderLayer(RegistrySC.ModBlocks.TURTLE_SC.get(), RenderType.getTranslucent());
		ClientRegistry.bindTileEntityRenderer(RegistrySC.ModTiles.TURTLE_SC.get(), TileEntityTurtleSCRenderer::new);
	}
	
	@SubscribeEvent
	public static void registerModels(ModelRegistryEvent event) {
		ModelLoaderRegistry.registerLoader(
				new ResourceLocation(SCGlobal.MOD_ID, "turtle_sc"), TurtleSCModelLoader.INSTANCE);
	}
	
	@SubscribeEvent
	public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
		if(event.getMap().getTextureLocation().equals(PlayerContainer.LOCATION_BLOCKS_TEXTURE)) {
			event.addSprite(new ResourceLocation(SCGlobal.MOD_ID, "block/turtle_sc_color"));
		}
	}
	
	@SubscribeEvent
	public static void onModelBakeEvent(ModelBakeEvent event) {
		ModelLoader loader = event.getModelLoader();
		Map<ResourceLocation, IBakedModel> registry = event.getModelRegistry();
		String modelName = "turtle_sc_color";
		ResourceLocation location = new ResourceLocation(SCGlobal.MOD_ID, "item/" + modelName);
		IUnbakedModel model = loader.getUnbakedModel(location);
		model.getTextures(loader::getUnbakedModel, new HashSet<>());
		IBakedModel baked = model.bakeModel(loader, ModelLoader.defaultTextureGetter(), SimpleModelTransform.IDENTITY, location);
		registry.put(new ModelResourceLocation(new ResourceLocation(SCGlobal.MOD_ID, modelName), "inventory"), baked);
	}
	
	@SubscribeEvent
	public static void onItemColours(ColorHandlerEvent.Item event) {
		
		// Register turtle colors.
		event.getItemColors().register(
				(stack, tintIndex) -> tintIndex == 0 ? ((IColouredItem) stack.getItem()).getColour(stack) : 0xFFFFFF,
				RegistrySC.ModBlocks.TURTLE_SC.get());
	}
}
