package computercraftsc.client.gui.container.slot;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;

public abstract class ButtonSlot extends Slot {
	
	public ButtonSlot(IInventory inventory, int xPosition, int yPosition) {
		super(inventory, 0, xPosition, yPosition);
	}
	
	/**
	 * Called when this {@link ButtonSlot} is clicked.
	 * @param mode - The click mode. See {@link https://wiki.vg/Protocol#Click_Window} for a full table of click modes
	 * and buttons.
	 * @param clickedButton - The clicked button, which's meaning depends on the click mode.
	 * @param player - The clicking player.
	 */
	public abstract void onSlotClicked(ClickType clickType, int clickedButton, PlayerEntity player);
}
