package computercraftsc.client.gui.container.slot;

import computercraftsc.client.gui.inventories.InventoryManager;
import computercraftsc.shared.turtle.block.TileTurtleSC;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.item.ItemStack;

public class GarbageButtonSlot extends ButtonSlot {
	
	private final TileTurtleSC tileTurtleSC;
	
	public GarbageButtonSlot(TileTurtleSC tileTurtleSC, IInventory inventory, int xPosition, int yPosition) {
		super(inventory, xPosition, yPosition);
		this.tileTurtleSC = tileTurtleSC;
	}
	
	@Override
	public void onSlotClicked(ClickType clickType, int clickedButton, PlayerEntity player) {
		if(clickType == ClickType.PICKUP) {
			ItemStack heldItemStack = player.inventory.getItemStack();
			InventoryManager inventoryManager = this.tileTurtleSC.getInventoryManager();
			switch(clickedButton) {
				
				// Left click: Discard all held items, or clear the coding inventory when no items are held.
				case 0: {
					if(heldItemStack.isEmpty()) {
						
						// Clear coding inventory.
						if(!this.tileTurtleSC.getInventoriesLocked()) {
							inventoryManager.getCodingInventory().clearFullProgram(inventoryManager.isConfigMode());
						}
					} else {
						
						// Return held stack to programming inventory.
						player.inventory.setItemStack(ItemStack.EMPTY);
						inventoryManager.getProgrammingInventory().returnItemStack(heldItemStack);
					}
					break;
				}
				
				// Right click: Discard one held item, or clear the coding inventory when no items are held.
				case 1: {
					if(heldItemStack.isEmpty()) {
						
						// Clear coding inventory.
						if(!this.tileTurtleSC.getInventoriesLocked()) {
							inventoryManager.getCodingInventory().clearFullProgram(inventoryManager.isConfigMode());
						}
					} else {
						
						// Return one item from held stack to programming inventory.
						if(heldItemStack.getCount() > 0) {
							inventoryManager.getProgrammingInventory()
									.returnItemStack(heldItemStack.split(1));
						}
						if(heldItemStack.getCount() <= 0) {
							player.inventory.setItemStack(ItemStack.EMPTY);
						}
					}
					break;
				}
			}
		}
	}
}
