package computercraftsc.client.gui.container.slot;

import computercraftsc.shared.turtle.block.TileTurtleSC;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;

public class RunButtonSlot extends ButtonSlot {
	
	private final TileTurtleSC tileTurtleSC;
	
	public RunButtonSlot(TileTurtleSC tileTurtleSC, IInventory inventory, int xPosition, int yPosition) {
		super(inventory, xPosition, yPosition);
		this.tileTurtleSC = tileTurtleSC;
	}
	
	@SuppressWarnings("resource")
	@Override
	public void onSlotClicked(ClickType clickType, int clickedButton, PlayerEntity player) {
		if(!this.tileTurtleSC.getWorld().isRemote
				&& clickType == ClickType.PICKUP && player.inventory.getItemStack().isEmpty()) {
			this.tileTurtleSC.handlePlayButtonPress();
		}
	}
}
