package computercraftsc.client.gui.container.slotmanager;

import computercraftsc.client.gui.inventories.Inventory;
import net.minecraft.inventory.container.Slot;

import java.util.List;

import static computercraftsc.client.gui.GuiConstants.SLOT_SIZE;
import static computercraftsc.client.gui.GuiConstants.INVISIBLE_LOCATION;
import static computercraftsc.client.gui.GuiConstants.SPACE_BETWEEN_PLAYER_BAR_AND_INVENTORY;


/**
 * This class manages the Slots for PlayerInventory.
 * This class is created because the order of the grid of the Player Inventory is constructed differently.
 */
public class PlayerInventorySlotManager extends InventorySlotManager {

	public PlayerInventorySlotManager(List<Slot> slots, Inventory inventory, int xOffset, int yOffset) {
		super(slots, inventory, xOffset, yOffset);
	}

	@Override
	public void setSlotsVisible(boolean visible) {
		// move all slots to invisible locations, not sure if this is needed for playerInventory
		for (Slot slot : this.slots) {
			slot.xPos = INVISIBLE_LOCATION;
			slot.yPos = INVISIBLE_LOCATION;
		}

		if (visible) {
			int rowsExceptLast = this.inventory.getVisibleRows() - 1;
			//The First row is the Player Bar, this is displayed at the bottom.
			int index = this.placeSlotsInRow(0, this.inventory.getColumns(), this.xOffset,
					this.yOffset + SLOT_SIZE * rowsExceptLast + SPACE_BETWEEN_PLAYER_BAR_AND_INVENTORY);

			int yOffset = this.yOffset;
			// After that the rows are created from the top down
			for (int rows = 0; rows < rowsExceptLast; rows++) {
				index = this.placeSlotsInRow(index, this.inventory.getColumns(), this.xOffset, yOffset);
				yOffset += SLOT_SIZE;
			}
		}
	}

}
