package computercraftsc.client.gui.inventories;

import computercraftsc.client.gui.container.slot.TurtleSlot;
import net.minecraft.inventory.container.Slot;

import static computercraftsc.client.gui.GuiConstants.TURTLE_INVENTORY_COLUMNS;
import static computercraftsc.client.gui.GuiConstants.TURTLE_INVENTORY_ROWS;

/**
 * This class is used for the Turtle Inventory.
 * It holds so special interactions but is created for clarity.
 *
 * It is important that this Inventory is added first ass the Turtle Logic claims
 * the first 16 slots.
 */
public class TurtleInventory extends Inventory {

	/**
	 * The Rows and Columns are set they should always be the same.
	 */
	public TurtleInventory() {
		super(TURTLE_INVENTORY_COLUMNS, TURTLE_INVENTORY_ROWS);
	}

	@Override
	public Slot createSlot(int index, int xPosition, int yPosition) {
		return new TurtleSlot(this, index, xPosition, yPosition);
	}
}
